package cn.gtmap.hlw.core.domain.dyxx.model;

import cn.gtmap.hlw.core.dto.sqxx.save.QlrDTO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/5/17
 * @description
 */
@Data
public class BdczmThirdResultModel {
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 抵押证明号 对应 bdcdjzmh
     */
    private String dyzmh;
    /**
     * 抵押金额（被担保债权数额）
     */
    private String dyje;
    /**
     * 抵押方式（代码） 放代码
     */
    private String dyfs;
    /**
     * 抵押方式（名称） 放名称
     */
    private String dyfsmc;
    /**
     * 抵押范围
     */
    private String dyfw;
    /**
     * 抵押开始时间 YYYY-MM-DD
     */
    private String dykssj;
    /**
     * 抵押结束时间 YYYY-MM-DD
     */
    private String dyjssj;
    /**
     * 附记
     */
    private String fj;
    /**
     * 证明项目ID 对应 zmxmid
     */
    private String xmid;
    /**
     * 证书来源（2：新证书3：老证书） 对应 Zmly
     */
    private String zsly;
    /**
     * 不动产单元编号
     */
    private String bdcdybh;
    /**
     * 证书项目id
     */
    private String zsxmid;
    /**
     * 区域代码 对应 xzqhszdm
     */
    private String qydm;
    /**
     * 区域名称
     */
    private String qymc;
    /**
     * 不动产类型
     */
    private String bdclx;
    /**
     * 不动产类型名称
     */
    private String bdclxmc;
    /**
     * 担保范围
     */
    private String dbfw;

    /**
     * 是否禁止抵押期间抵押物转让放代码，1：禁止，0：同意
     */
    private String sfjzdyqjdywzrdm;
    /**
     * 是否禁止抵押期间抵押物转让放名称，1：禁止，0：同意
     */
    private String sfjzdyqjdywzrmc;
    /**
     * 证明权利或事项
     */
    private String zmqlhsx;
    /**
     * 房屋房号 ROOMID
     */
    private String fwfh;
    /**
     * 最高债权额）
     */
    private Double zgzqe;
    /**
     * 不动产价值 对应 dywjz
     */
    private Double bdcjz;
    /**
     * 币种代码
     */
    private String bzdm;
    /**
     * 币种名称
     */
    private String bzmc;
    /**
     * 其他权利状况 qlqtzk
     */
    private String qtqlzk;
    /**
     * 证书打印次数
     */
    private String zsdycs;
    /**
     * 建筑面积
     */
    private String jzmj;
    /**
     * 规划用途
     */
    private String ghyt;
    /**
     * 规划用途名称
     */
    private String ghytmc;
    /**
     * 宗地用途
     */
    private String zdyt;
    /**
     * 宗地用途名称
     */
    private String zdytmc;
    /**
     * 宗地宗海面积
     */
    private String zdzhmj;
    /**
     * 登记时间
     */
    private String djsj;
    /**
     * 抵押人信息
     */
    private List<QlrDTO> dyrList;
    /**
     * 抵押权人信息
     */
    private List<QlrDTO> dyqrList;
}
