package cn.gtmap.hlw.core.constant.redis;

import cn.gtmap.hlw.core.dto.workflow.query.WorkFlowQueryDTO;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2024/8/13
 * @description
 */
public class RedisHotDataKeyConstant {

    /**
     * 首页KEY
     */
    public static final String ROUTES_ROLE_GUID = "routes_role_guid:";

    public static String getRoutesRoleGuid(String roleid, String guid) {
        return ROUTES_ROLE_GUID + roleid + guid;
    }

    /**
     * 首页KEY
     */
    public static final String DETAIL_ROLE_GUID = "detail_role_guid:";

    public static String getDetailRoleGuid(String roleid, String guid) {
        return DETAIL_ROLE_GUID + roleid + guid;
    }

    /**
     * app详情
     */
    public static final String APP_DETAIL_ROLE_GUID = "app_detail_role_guid:";

    public static String getAppDetailRoleGuid(String roleid, String guid) {
        return APP_DETAIL_ROLE_GUID + roleid + guid;
    }

    /**
     * app服务
     */
    public static final String APP_SERVICE_ROLE_GUID = "app_service_role_guid:";

    public static String getAppServiceRoleGuid(String roleid, String guid) {
        return APP_SERVICE_ROLE_GUID + roleid + guid;
    }

    /**
     * app个人中心
     */
    public static final String APP_MINE_ROLE_GUID = "app_mine_role_guid:";

    public static String getAppMineRoleGuid(String roleid, String guid) {
        return APP_MINE_ROLE_GUID + roleid + guid;
    }
    /**
     * 首页KEY
     */
    public static final String WORK_FLOW_QUERY = "work_flow_query:";

    public static String getWorkFlowQuery(WorkFlowQueryDTO workFlowQueryDTO) {
        if (workFlowQueryDTO != null) {
            return WORK_FLOW_QUERY + workFlowQueryDTO.getSqlxdm() + workFlowQueryDTO.getRoleId() + workFlowQueryDTO.getClientType() + workFlowQueryDTO.getType() + workFlowQueryDTO.getFunctionMenuId();
        }
        return WORK_FLOW_QUERY + UUID.randomUUID();
    }

    public static String getWorkFlowQueryDelete(String sqlx) {
        if (StringUtils.isNotBlank(sqlx)) {
            return WORK_FLOW_QUERY + sqlx;
        }
        return WORK_FLOW_QUERY;
    }



    public static String getOrderDateOrgid(String orgid) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        String currentDate = dateFormat.format(calendar.getTime());
        return RedisKeyConstant.ORDER_DATE_ORGID + currentDate + orgid;
    }

    public static String getOrderDateOrgidDelete() {
        return RedisKeyConstant.ORDER_DATE_ORGID;
    }
}
