package cn.gtmap.hlw.core.dto.third.cqxx.page;

import cn.gtmap.hlw.core.base.BasePage;
import lombok.Data;

import java.io.Serializable;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/17 13:52
 * @description 产权分页查询入参
 */
@Data
public class CqxxPageThirdQueryParamsDTO extends BasePage implements Serializable {
    /**
     * 步骤id
     */
    private String processId;
    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 权利人名称模糊
     */
    private String qlrmcmh;

    /**
     * 权利人证件号
     */
    private String qlrzjh;

    /**
     * 证书类型
     * 3.0,1:证书，2：证明3：证明书
     */
    private String zslx;

    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 不动产单元号模糊
     */
    private String bdcdyhmh;

    /**
     * 坐落
     */
    private String zl;


    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 产权证号模糊
     */
    private String cqzhmh;

    /**
     * 产权证号简称
     */
    private String cqzhjc;

    /**
     * 权利类型，多个英文逗号隔开
     */
    private String qllxs;

    /**
     * 不动产权证号
     */
    private String bdcqzh;

    /**
     * 权属状态
     */
    private String qszt;
}
