package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyApiUser;

/**
 * (GxYyApiUser)表数据库访问层
 *
 * @author makejava
 * @since 2023-10-12 17:44:50
 */
public interface GxYyApiUserRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param userid 主键
     * @return 实例对象
     */
    GxYyApiUser get(String userid);

    /**
     * 新增数据
     *
     * @param gxYyApiUser 实例对象
     * @return 影响行数
     */
    void save(GxYyApiUser gxYyApiUser);

    /**
     * 修改数据
     *
     * @param gxYyApiUser 实例对象
     * @return 影响行数
     */
    void update(GxYyApiUser gxYyApiUser);

    /**
     * 根据用户名和密码判断
     *
     * @param username
     * @param password
     * @return:GxYyApiUser
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyApiUser get(String username, String password);
}

