package cn.gtmap.hlw.core.po;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/2/25
 * @description 对公月结缴费
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("gx_yy_dg_yjjf")
public class GxYyDgYjjfPO extends Model<GxYyDgYjjfPO> implements Serializable {
    /**
     * 月结单号
     */
    @TableId("yjdh")
    private String yjdh;
    /**
     * 总金额
     */
    @TableField("zje")
    private Double zje;
    /**
     * 缴款人名称
     */
    @TableField("jkrmc")
    private String jkrmc;
    /**
     * 缴款人证件号
     */
    @TableField("jkrzjh")
    private String jkrzjh;
    /**
     * 收费项目数量
     */
    @TableField("sfxmsl")
    private Integer sfxmsl;
    /**
     * 缴付款识别码（非税缴款识别码）
     */
    @TableField("jksbm")
    private String jksbm;
    /**
     * 虚拟子账号（非税虚拟子账号，收款方账号）
     */
    @TableField("xnzzh")
    private String xnzzh;
    /**
     * 收款方名称（收款方对公账户名称）
     */
    @TableField("skfmc")
    private String skfmc;
    /**
     * 开户行（收款方账户开户银行名称）
     */
    @TableField("khh")
    private String khh;
    /**
     * 银行名称
     */
    @TableField("yhmc")
    private String yhmc;
    /**
     * 区县代码
     */
    @TableField("qxdm")
    private String qxdm;
    /**
     * 登簿起始时间
     */
    @TableField("dbqssj")
    private Date dbqssj;
    /**
     * 登簿结束时间
     */
    @TableField("dbjssj")
    private Date dbjssj;
}
