package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2024/3/7
 * @description 查封类型枚举
 */
@Getter
@AllArgsConstructor
public enum CflxEnum {


    CFLX_CF("1", "查封"),
    CFLX_LHCF("2", "轮候查封"),
    CFLX_YCF("3", "预查封"),
    CFLX_LHYCF("4", "轮候预查封"),
    CFLX_XF("5", "续封");


    /**
     * 代码
     */
    @Getter
    private String dm;

    /**
     * 名称
     */
    @Getter
    private String mc;

    public static String getMc(String dm) {
        for (CflxEnum xq : CflxEnum.values()) {
            if (xq.dm.equals(dm)) {
                return xq.getMc();
            }
        }
        return null;
    }
}
