package cn.gtmap.hlw.core.dto.third.cqzdyxx.dyzm;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.dto.sqxx.save.QlrDTO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/10/7 16:23
 * @description BdczmThridResultDTO
 */
@Data
public class BdczmThridResultDTO {
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 抵押证明号 对应 bdcdjzmh
     */
    private String dyzmh;
    /**
     * 抵押金额（被担保债权数额）
     */
    private String dyje;
    /**
     * 抵押金额类型
     */
    @ZdDzConfig(field = "dyjelx", tableName = ZdDzConstant.ZD_DZ_DYJELX, dmToDm = true)
    private String dyjelx;
    /**
     * 抵押方式（代码） 放代码
     */
    @ZdDzConfig(field = "dyfs", tableName = ZdDzConstant.ZD_DZ_DYFS, mcToDM = true)
    private String dyfs;
    /**
     * 抵押方式（名称） 放名称
     */
    private String dyfsmc;
    /**
     * 抵押范围
     */
    private String dyfw;
    /**
     * 权利类型
     */
    private String qllx;
    /**
     * 抵押开始时间 YYYY-MM-DD
     */
    private String dykssj;
    /**
     * 抵押结束时间 YYYY-MM-DD
     */
    private String dyjssj;
    /**
     * 附记
     */
    private String fj;
    /**
     * 证明项目ID 对应 zmxmid
     */
    private String xmid;
    /**
     * 证书来源（2：新证书3：老证书） 对应 Zmly
     */
    private String zsly;
    /**
     * 不动产单元编号
     */
    private String bdcdybh;
    /**
     * 证书项目id
     */
    private String zsxmid;
    /**
     * 区域代码 对应 xzqhszdm
     */
    private String qydm;
    /**
     * 区域名称
     */
    private String qymc;
    /**
     * 不动产类型
     */
    @ZdDzConfig(field = "bdclx", tableName = ZdDzConstant.ZD_DZ_BDCLX, dmToDm = true)
    private String bdclx;
    /**
     * 不动产类型名称
     */
    private String bdclxmc;
    /**
     * 担保范围
     */
    private String dbfw;

    /**
     * 是否禁止抵押期间抵押物转让放代码，1：禁止，0：同意
     */
    private String sfjzdyqjdywzrdm;
    /**
     * 是否禁止抵押期间抵押物转让放名称，1：禁止，0：同意
     */
    private String sfjzdyqjdywzrmc;
    /**
     * 证明权利或事项
     */
    private String zmqlhsx;
    /**
     * 房屋房号 ROOMID
     */
    private String fwfh;
    /**
     * 最高债权额）
     */
    private Double zgzqe;
    /**
     * 不动产价值 对应 dywjz
     */
    private Double bdcjz;
    /**
     * 币种代码
     */
    private String bzdm;
    /**
     * 币种名称
     */
    private String bzmc;
    /**
     * 其他权利状况 qlqtzk
     */
    private String qtqlzk;
    /**
     * 证书打印次数
     */
    private String zsdycs;
    /**
     * 建筑面积
     */
    private String jzmj;
    /**
     * 规划用途
     */
    private String ghyt;
    /**
     * 规划用途名称
     */
    private String ghytmc;
    /**
     * 宗地用途
     */
    private String zdyt;
    /**
     * 宗地用途名称
     */
    private String zdytmc;
    /**
     * 宗地宗海面积
     */
    private String zdzhmj;
    /**
     * 登记时间
     */
    private String djsj;
    /**
     * 抵押顺位
     */
    private String dysw;
    /**
     * 贷款方式
     */
    private String dkfs;

    /**
     * 房屋结构
     */
    private String fwjg;

    /**
     * 竣工时间
     */
    private String jgsj;

    /**
     * 所在层
     */
    private String szc;

    /**
     * 总层数
     */
    private String zcs;

    /**
     * 房屋幢号
     */
    private String fwzh;

    /**
     * 房屋性质(代码)
     */
    private String fwxz;

    /**
     * 房屋类型(代码)
     */
    private String fwlx;

    /**
     * 宗地/宗海权利类型
     */
    private String zdzhqllx;

    /**
     * 土地使用起始时间
     */
    private String tdsyqssj;

    /**
     * 土地使用结束时间
     */
    private String tdsyjssj;

    /**
     * 分摊土地面积
     */
    private String fttdmj;

    /**
     * 宗地/宗海权利性质
     */
    private String zdzhqlxz;
    /**
     * 房屋抵押面积
     */
    private String fwdymj;
    /**
     * 土地抵押面积
     */
    private String tddymj;

    /**
     * 证明类型代码（1：纸质证 2：电子证（3.0））
     */
    private String zmlxdm;
    /**
     * 证明类型名称
     */
    private String zmlxmc;
    /**
     * 是否锁定 (1:是，0：否)
     */
    private String sfsd;
    /**
     * 抵押物价值
     */
    private String dywjz;

    /**
     * 抵押人信息
     */
    @ZdDzConfig(field = "dyrList", tableName = "", isList = true)
    private List<QlrDTO> dyrList;

    private List<QlrDTO> qlr;
    /**
     * 抵押权人信息
     */
    @ZdDzConfig(field = "dyqrList", tableName = "", isList = true)
    private List<QlrDTO> dyqrList;
    private List<QlrDTO> dyqlr;
    /**
     * 附件信息
     */
    private List<BdczmThirdFjxxDTO> fjxxList;
}
