package cn.gtmap.hlw.core.domain.sfxx.model.detail;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/2
 * @description
 */
@Data
public class WctSfssxxResultModel {
    /**
     * 收费收税信息id
     */
    private String sfssxxid;

    /**
     * 项目id
     */
    private String xmid;

    /**
     * 权利人类别
     */
    private String qlrlb;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 执收单位名称
     */
    private String zsdwmc;

    /**
     * 执收单位代码
     */
    private String zsdwdm;

    /**
     * 内网受理编号(蚌埠为互联网slbh)
     */
    private String nwslbh;

    /**
     * 缴费状态(0:未缴费 1:部分缴费 2:已缴费)
     */
    private String jfzt;
    /**
     * 缴费状态名称
     */
    private String jfztmc;

    /**
     * 是否月结(0：否；1：是)
     */
    private String sfyj;
    /**
     * 登记费信息
     */
    private List<WctDjxxResultModel> djxxList;
    /**
     * 核税信息
     */
    private List<WctHsxxResultModel> hsxxList;

    /**
     * 维修基金信息
     */
    private List<WctWxjjResultModel> wxjjList;

    /**
     * 申请人信息
     */
    private List<WctSqrResultModel> sqrList;
}
