/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.pdf;

import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(TransformUtil.class);
    private static Map<String, String> bdcdyhDzqllxMcMap = Maps.newHashMap();

    public TransformUtil() {
        bdcdyhDzqllxMcMap.put("GB:W", "\u56fd\u6709\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743");
        bdcdyhDzqllxMcMap.put("JC:W", "\u5b85\u57fa\u5730\u4f7f\u7528\u6743");
        bdcdyhDzqllxMcMap.put("ZC:W", "\u5b85\u57fa\u5730\u4f7f\u7528\u6743");
        String jtjsydsyq = "\u96c6\u4f53\u5efa\u8bbe\u7528\u5730\u4f7f\u7528\u6743";
        bdcdyhDzqllxMcMap.put("JB:W", jtjsydsyq);
        bdcdyhDzqllxMcMap.put("ZB:W", jtjsydsyq);
        bdcdyhDzqllxMcMap.put("ZS:W", jtjsydsyq);
        bdcdyhDzqllxMcMap.put("ZX:W", jtjsydsyq);
    }

    public static void main(String[] args) {
        String id = "340122730306245";
        LOGGER.info("18\u4f4d\u8eab\u4efd\u8bc1\uff1a{}", (Object)TransformUtil.idCardNumOldChangeNew(id));
    }

    public static String double6ToStr(Double d) {
        if (d == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(6);
        return nf.format(d);
    }

    public static String double2ToStr(Double d) {
        if (d == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        return nf.format(d);
    }

    public static String doubleToStrNoZeros(Double d) {
        if (d == null) {
            return "";
        }
        BigDecimal value = BigDecimal.valueOf(d);
        BigDecimal noZeros = value.stripTrailingZeros();
        String result = noZeros.toPlainString();
        return result;
    }

    public static String idCardNumOldChangeNew(String idCardNumOld) {
        String idCardNumNew = StringUtils.trim((String)idCardNumOld);
        if (StringUtils.isBlank((CharSequence)idCardNumNew)) {
            return "";
        }
        if (18 == idCardNumNew.trim().length()) {
            return idCardNumNew;
        }
        if (15 == idCardNumNew.trim().length()) {
            String id = idCardNumNew;
            id = id.length() == 15 ? id.substring(0, 6) + "19" + id.substring(6, id.length()) : id;
            String[] c = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
            String[] b = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
            Integer sum = 0;
            for (int i = 0; i < id.length(); ++i) {
                sum = sum + Integer.parseInt(c[i]) * Integer.parseInt(String.valueOf(id.charAt(i)));
            }
            Integer index = sum % 11;
            return id + String.valueOf(b[index]);
        }
        return null;
    }

    public static String turnIdCardFrom18To15(String str) {
        if (str.length() == 18) {
            return str.substring(0, 6) + str.substring(8, 17);
        }
        return str;
    }

    public static String transformJsonKeyUpperCase(String json) {
        String regex = "[\\\"' ]*[^:\\\"' ]*[\\\"' ]*:";
        Pattern pattern = Pattern.compile(regex);
        StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(json);
        while (m.find()) {
            m.appendReplacement(sb, m.group().toUpperCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String transformJsonKeyLowerCase(String json) {
        String regex = "[\\\"' ]*[^:\\\"' ]*[\\\"' ]*:";
        Pattern pattern = Pattern.compile(regex);
        StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(json);
        while (m.find()) {
            m.appendReplacement(sb, m.group().toLowerCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String jeTransYuan(Object je) {
        String jeYuan = "";
        if (je == null || StringUtils.isBlank((CharSequence)String.valueOf(je))) {
            return jeYuan;
        }
        String jeSzDw = AppConfig.getProperty((String)"je.sz.dw");
        jeSzDw = StringUtils.isNotBlank((CharSequence)jeSzDw) ? jeSzDw.trim() : "\u4e07\u5143";
        if (StringUtils.equals((CharSequence)jeSzDw, (CharSequence)"\u4e07\u5143")) {
            Double jyjg = new BigDecimal(String.valueOf(je)).multiply(BigDecimal.valueOf(10000L)).doubleValue();
            jeYuan = TransformUtil.double2ToStr(jyjg);
        } else if (StringUtils.equals((CharSequence)jeSzDw, (CharSequence)"\u5143")) {
            if (je instanceof Double) {
                DecimalFormat df = new DecimalFormat("##0.00");
                jeYuan = df.format(je);
            } else {
                jeYuan = String.valueOf(je);
            }
        }
        return jeYuan;
    }

    public static String yuanTransJe(Object je) {
        String jeYuan = "";
        if (je == null || StringUtils.isBlank((CharSequence)String.valueOf(je))) {
            return jeYuan;
        }
        String jeSzDw = AppConfig.getProperty((String)"je.sz.dw");
        jeSzDw = StringUtils.isNotBlank((CharSequence)jeSzDw) ? jeSzDw.trim() : "\u4e07\u5143";
        if (StringUtils.equals((CharSequence)jeSzDw, (CharSequence)"\u4e07\u5143")) {
            Double jyjg = new BigDecimal(String.valueOf(je)).divide(BigDecimal.valueOf(10000L)).doubleValue();
            jeYuan = TransformUtil.double6ToStr(jyjg);
        } else if (StringUtils.equals((CharSequence)jeSzDw, (CharSequence)"\u5143")) {
            if (je instanceof Double) {
                DecimalFormat df = new DecimalFormat("##0.00");
                jeYuan = df.format(je);
            } else {
                jeYuan = String.valueOf(je);
            }
        }
        return jeYuan;
    }

    public static String bdcdyhTransQllx(String bdcdyh) {
        boolean flag2;
        boolean flag1;
        boolean flag;
        String qllx = "";
        if (StringUtils.isBlank((CharSequence)bdcdyh)) {
            return qllx;
        }
        String zdhszm = StringUtils.substring((String)bdcdyh, (int)12, (int)14);
        String dzwdwdmszm = StringUtils.substring((String)bdcdyh, (int)19, (int)20);
        String bdcdyhDzqllxKey = zdhszm + ":" + dzwdwdmszm;
        String qllxMc = bdcdyhDzqllxMcMap.get(bdcdyhDzqllxKey);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zdhszm, dzwdwdmszm}) && StringUtils.equals((CharSequence)zdhszm, (CharSequence)"GB") && StringUtils.equals((CharSequence)dzwdwdmszm, (CharSequence)"W")) {
            qllx = "3";
        }
        boolean bl = flag = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zdhszm, dzwdwdmszm}) && (StringUtils.equals((CharSequence)zdhszm, (CharSequence)"JC") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZC")) && StringUtils.equals((CharSequence)dzwdwdmszm, (CharSequence)"W");
        if (flag) {
            qllx = "5";
        }
        boolean bl2 = flag1 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zdhszm, dzwdwdmszm}) && (StringUtils.equals((CharSequence)zdhszm, (CharSequence)"JB") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZB") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZS") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZX")) && StringUtils.equals((CharSequence)dzwdwdmszm, (CharSequence)"W");
        if (flag1) {
            qllx = "7";
        }
        boolean bl3 = flag2 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zdhszm}) && (StringUtils.equals((CharSequence)zdhszm, (CharSequence)"GD") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"GE") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"GF") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"JD") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"JE") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"JF") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZD") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZE") || StringUtils.equals((CharSequence)zdhszm, (CharSequence)"ZF"));
        if (flag2) {
            qllx = "9";
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zdhszm}) && StringUtils.equalsAny((CharSequence)zdhszm, (CharSequence[])new CharSequence[]{"ZH", "GH"})) {
            qllx = "13";
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zdhszm}) && StringUtils.equalsAny((CharSequence)zdhszm, (CharSequence[])new CharSequence[]{"GG", "ZG"})) {
            qllx = "15";
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dzwdwdmszm}) && StringUtils.equals((CharSequence)dzwdwdmszm, (CharSequence)"F")) {
            qllx = "";
        }
        return qllx;
    }

    public static String formatToDecimalPlaces(String numberStr, int scale) {
        if (StringUtils.isBlank((CharSequence)numberStr)) {
            return numberStr;
        }
        try {
            BigDecimal number = new BigDecimal(numberStr);
            number = number.setScale(scale, RoundingMode.HALF_UP);
            return number.toPlainString();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format");
        }
    }
}

