package cn.gtmap.gtc.sso.domain.enums;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/8/23
 * @description
 */
public class UrlAccessEnum {

    public enum AccessType{

        HAS_USER("HAS_USER", "用户限制"),
        HAS_ROLE("HAS_ROLE", "角色限制"),
        HAS_ORG("HAS_ORG", "组织限制"),
        HAS_IP("HAS_IP", "IP限制"),
        HAS_SCOPE("HAS_SCOPE", "接口资源范围限制"),
        HAS_AUTHENTICATED("HAS_AUTHENTICATED", "认证限制"),
        UNLIMITED("UNLIMITED", "不限制"),
        DENY("DENY", "拒绝访问"),
        UNKNOWN("UNKNOWN", "未知限制");

        private String value;

        private String remark;

        public String getValue() {
            return value;
        }

        public String getRemark() {
            return remark;
        }

        AccessType(String value, String remark) {
            this.value = value;
            this.remark = remark;
        }

        public static AccessType enumValue(String type){
            try {
                AccessType accessType = valueOf(type);
                return accessType;
            }catch (Exception e){
                return UNKNOWN;
            }
        }
    }

    public enum Ref{

        AND("AND", "并"),
        OR("OR", "或");

        private String value;

        private String remark;

        public String getValue() {
            return value;
        }

        public String getRemark() {
            return remark;
        }

        Ref(String value, String remark) {
            this.value = value;
            this.remark = remark;
        }

        public static Ref enumValue(String type){
            try {
                Ref ref = valueOf(type);
                return ref;
            }catch (Exception e){
                return OR;
            }
        }
    }
}
