package cn.gtmap.gtc.sso.domain.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/9/27
 * @description
 */

@Data
public class UserStatusDto implements Serializable {
    private static final long serialVersionUID = 7670919974971145680L;

    /*
     *  主键
     * */
    private String id;

    /*
     *  用户名/登陆账户，数字/字母
     * */
    private String username;

    /*
     *  别称（中文姓名）
     * */
    private String alias;

    //在线状态
    private int online = 0;

    private String sessionId;

    private Date loginTime;

    private String remoteAddr;

    private String remoteMac;
    /*
     *  拥有角色列表
     * */
    private List<RoleDto> roleRecordList;

    /*
     *  拥有组织机构列表
     * */
    private List<OrganizationDto> orgRecordList;
}
