package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 用户请假信息
 *
 * @author wqy
 * @date 2023/04/18
 */

@Data
public class UserLeaveDto {

    private static final long serialVersionUID = 1L;

    private String id;
    private int enabled;
    private String isExecuted;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;
    /**
     * 请假的用户
     */
    private String username;

    /**
     * 姓名
     */
    private String alias;

    /**
     * 请假理由
     */
    private String reason;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date leaveStartTime;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date leaveEndTime;

    /**
     * 开启请假操作人用户名
     */
    private String startLeaveOperatorName;

    /**
     * 开启请假操作人用户名
     */
    private String startLeaveOperatorAlias;

    /**
     * 设置请假状态时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date operateStartTime;

    /**
     * 解除请假状态操作时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date operateEndTime;

    /**
     * 解除请假状态操作人用户名
     */
    private String endLeaveOperatorAlias;

    /**
     * 解除请假状态操作人用户名
     */
    private String endLeaveOperatorName;

    /**
     * 请假类型，continuous：连续，interval：间隔
     */
    private String leaveType;

    public String getLeaveType() {
        if (StringUtils.isEmpty(leaveType)) {
            return "continuous";
        }
        return leaveType;
    }

    public void setLeaveType(String leaveType) {
        this.leaveType = leaveType;
    }
}
