package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/4
 * @description
 */
@Getter
@Setter
public class UserCollectionDto implements Serializable {
    /*
     *  主键Id
     * */
    private String id;


    /*
     *  编码
     * */
    private String code;


    /*
     *  名称
     * */
    private String name;

    /*
     *  内容
     * */
    private String content;

    /*
     *  收藏类型
     * */
    private String type;

    /*
     *  收藏类型名称
     * */
    private String typeName;


    /*
     *  排序
     * */
    private int sequenceNumber;


    /*
     *  创建时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    /*
     *  拓展字段1
     * */
    private String ext1;

    /*
     *  拓展字段2
     * */
    private String ext2;

    /*
     *  拓展字段3
     * */
    private String ext3;
}
