package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class LogMsgDTO implements Serializable {
    private static final long serialVersionUID = -7112232992043267734L;

    //注册中心的应用名称如 account/storage-app
    private String gtcAppName;
    //事件类型
    private String event;

    //数据主键 可不设置
    private String id;
    //默认保存到gtc-platform日志索引里面, 可不设置
    private String index = "platform";
    //身份信息/ 用户账号 可不设置
    private String principal;
    // 请求客户端IP 可不设置
    private String remoteAddr;
    //请求地址 可不设置
    private String httpUrl;
    //请求方法 可不设置
    private String httpMethod;
    //执行类名称 可不设置
    private String exeClass;
    //执行类方法 可不设置
    private String exeMethod;

    //自定义数据
    private Map<String, String> tags;

    //发生时间 匹配zipKin 数据格式
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date timestamp_millis;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIndex() {
        return index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getPrincipal() {
        return principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getRemoteAddr() {
        return remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getGtcAppName() {
        return gtcAppName;
    }

    public void setGtcAppName(String gtcAppName) {
        this.gtcAppName = gtcAppName;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getExeClass() {
        return exeClass;
    }

    public void setExeClass(String exeClass) {
        this.exeClass = exeClass;
    }

    public String getExeMethod() {
        return exeMethod;
    }

    public void setExeMethod(String exeMethod) {
        this.exeMethod = exeMethod;
    }

    public Date getTimestamp_millis() {
        return timestamp_millis;
    }

    public void setTimestamp_millis(Date timestamp_millis) {
        this.timestamp_millis = timestamp_millis;
    }

    public Map<String, String> getTags() {
        return tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}
