package cn.gtmap.gtc.sso.domain.dto;

import lombok.Getter;
import lombok.Setter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.*;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0, 2018/7/5
 * @description 用于spring-security 认证授权
 */

@Getter
@Setter
public class AuthUserDetails implements UserDetails {

    private static final long serialVersionUID = -8366929034564774130L;

    /*
     *  主键
     * */
    private String id;

    /*
     *  用户名/账户
     * */
    private String username;

    /*
     *  姓名
     * */
    private String alias;

    /*
     *  失效日期
     * */
    private Date expired;

    /*
     *  密码
     * */
    private String password;

    /*
     *  1：禁用 0：正常
     * */
    private int enabled;

    /*
     *  1：锁定 0：正常
     * */
    private int locked;

    // 1: 已修改原始密码  0： 未原始密码
    private Integer modifyPwd = 0;

    /*
     *  1 ：管理员
     * */
    private int admin;

    /*
     *  签名ID, 通过ID从文档中心下载签名图片
     * */
    private String signId;
    private Date createAt;
    private Date updateAt;
    /*
     *  手机号
     * */
    private String mobile;

    /*
     *  邮件
     * */
    private String email;

    /*
     *  办公电话
     * */
    private String tel;

    private Date birthday;

    /*
     *  性别
     * */
    private String gender;

    /*
     *  职位
     * */
    private String title;

    /*
     *  个人简介
     * */
    private String resume;

    /*
     *  地址
     * */
    private String address;


    /*
     *  人员排序
     * */
    private String sequenceNumber;

    /*
     *  拥有角色列表
     * */
    private List<RoleDto> roleRecordList;

    /*
     *  拥有组织机构列表
     * */
    private List<OrganizationDto> orgRecordList;

    /*
    * 远程登陆地址
    * */
    private String remoteAddr;

    /*
    * 身份证
    * */
    private String idCard;

    /*
    * 工号
    * */
    private String jobNumber;

    /*
     * 照片ID
     * */
    private String pictureId;

    Set<GrantedAuthority> authorities = new HashSet<>();

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return authorities;
    }

    @Override
    public boolean isAccountNonExpired() {

        if(null != this.getExpired() && (System.currentTimeMillis() > this.getExpired().getTime())){
            return false;
        }
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        if(0 == this.getLocked()){
            return true;
        }
        return false;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return isAccountNonExpired();
    }

    @Override
    public boolean isEnabled() {
        if(1 == this.getEnabled()){
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (null != o) {
            return this.hashCode() == o.hashCode();
        }
       return false;
    }

    @Override
    public int hashCode(){
        return this.id.hashCode();
    }

}
