package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.UrlAccessConfigDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/8/27
 * @description
 */

@FeignClient(name = "account")
@RequestMapping(value = "/account/rest/v1/urls")
public interface UrlAccessCfgClient {

    /**
     * @param clientId 应用ID
     * @return
     * @description 列表查询限制列表
     */
    @GetMapping("/list")
    List<UrlAccessConfigDto> listByClient(@RequestParam(name = "clientId") String clientId,
                                          @RequestParam(name = "accessType", required = false) String accessType);

    /**
     * @param dto 规则实体
     * @return
     * @description 新建/更新限制规则
     */
    @PostMapping
    UrlAccessConfigDto save(@RequestBody UrlAccessConfigDto dto);

    /**
     * @param ids 规则id列表
     * @return
     * @description 删除限制规则
     */
    @DeleteMapping
    void delete(@RequestParam(name = "ids") String ids);

    /**
     * @param id 主键
     * @return
     * @description 查询规则详情
     */
    @GetMapping
    UrlAccessConfigDto queryById(@RequestParam(name = "id") String id);

    @GetMapping("/modules")
    List<ModuleDto> queryModuleDto(@RequestParam(name = "id",required = false)String id,
                                          @RequestParam(name = "clientId") String clientId);
}
