package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.BaseResultDto;
import cn.gtmap.gtc.sso.domain.dto.DataAccessDto;
import cn.gtmap.gtc.sso.domain.dto.OAuth2AccessTokenDto;
import cn.gtmap.gtc.sso.domain.dto.UrlAuthAccessDto;
import cn.gtmap.gtc.sso.domain.mem.SecurityMetaUrlSource;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/8/3
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account")
public interface OauthManagerClient {

    /**
     * @param  username 用户名
     * @return
     * @description 根据用户名，权限码鉴权
     */
    @PostMapping("/oauth/token")
    OAuth2AccessTokenDto getAccessToken(@RequestParam(name = "grant_type") String grant_type,
                                        @RequestParam(name = "client_id") String client_id,
                                        @RequestParam(name = "client_secret") String client_secret,
                                        @RequestParam(name = "username", required = false) String username,
                                        @RequestParam(name = "password",required = false) String password,
                                        @RequestParam(name = "validitySeconds",required = false) String validitySeconds,
                                        @RequestParam(name = "customToken",required = false) String customToken);

    /**
     * @param  username 用户名
     * @param  authority 权限码
     * @param  clientId  应用编码
     * @return
     * @description 根据用户名，权限码鉴权
     */
    @GetMapping("/auth/check/module-authority")
    boolean checkUsernameAuthority(@RequestParam(name = "username") String username,
                                   @RequestParam(name = "authority") String authority,
                                   @RequestParam(name = "clientId",required = false) String clientId);

    /**
     * @param  username 用户名
     * @param  authority 权限码
     * @param  clientId  应用编码
     * @return
     * @description 根据用户名，url鉴权
     */
    @GetMapping("/auth/check/url-authority")
    boolean checkUrlAuthority(@RequestParam(name = "username") String username,
                              @RequestParam(name = "authority") String authority ,
                              @RequestParam(name = "path") String path,
                              @RequestParam(name = "clientId") String clientId,
                              @RequestParam(name = "method") String method);

    /**
     * @param  username 用户名
     * @param  moduleCode 模块编码
     * @param  clientId  应用编码
     * @return
     * @description 根据模块编码，获取权限码
     */
    @GetMapping("/auth/module/authority-code")
    String findModuleAuthority(@RequestParam(name = "username") String username,
                               @RequestParam(name = "moduleCode") String moduleCode ,
                               @RequestParam(name = "clientId",required = false) String clientId);

    /**
     * @param  username 用户名
     * @param  path 请求路径
     * @param  method GET POST DELETE....
     * @param  clientId  应用编码
     * @return
     * @description 根据用户名、url获取权限码
     */
    @GetMapping("/auth/url/authority-code")
    String findUrlAuthority(@RequestParam(name = "username") String username,
                            @RequestParam(name = "path") String path,
                            @RequestParam(name = "clientId") String clientId,
                            @RequestParam(name = "method", required = false) String method);

    /**
     * @param  username 用户名
     * @param  path 请求路径
     * @param  method GET POST DELETE....
     * @param  clientId  应用编码
     * @return root: 操作权限
     * @return elements: 元素权限
     * @description 根据用户名、url获取权限码
     */
    @GetMapping("/auth/menu/url-authority")
    Map<String, String> findMenuUrlAuthority(@RequestParam(name = "username") String username,
                                             @RequestParam(name = "path") String path,
                                             @RequestParam(name = "clientId") String clientId,
                                             @RequestParam(name = "method", required = false) String method);

    /**
     * @param  username 用户名
     * @param  moduleCode 模块编码
     * @param  clientId  应用编码
     * @return root: 操作权限
     * @return elements: 元素权限
     * @description 根据用户名，模块编码获取鉴权码
     */
    @GetMapping("/auth/menu/module-authority")
    Map<String, String> findMenuModuleAuthority(@RequestParam(name = "username") String username,
                                                @RequestParam(name = "moduleCode") String moduleCode ,
                                                @RequestParam(name = "clientId",required = false) String clientId);


    /**
     * @param  username 用户名
     * @description 根据用户名清除session
     */
    @DeleteMapping("/auth/session")
    void cleanSession(@RequestParam(name = "username") String username);

    /**
     * @param  dto 用户及url信息实体
     * @description url统一认证接口
     */
    @Deprecated
    @PostMapping("/auth/url/access")
    BaseResultDto urlAccess(@RequestBody UrlAuthAccessDto dto);


    /**
     * @param  clientId 应用ID
     * @description 获取应用URL访问配置
     */
    @GetMapping("/auth/client/access/config")
    List<SecurityMetaUrlSource> listClientUrlAccessConfig(@RequestParam(name = "clientId") String clientId);

    /**
     * @param  username 用户名
     * @param  dataType 数据类型
     * @param  code 数据编码
     * @description 数据鉴权服务，返回当前人员,角色，组织','拼接的鉴权码
     */
    @GetMapping("/auth/data/authority")
    String userDataAuthority(@RequestParam(name = "username", required = false) String username,
                             @RequestParam(name = "clientIp", required = false) String clientIp,
                             @RequestParam(name = "dataType") String dataType,
                             @RequestParam(name = "code") String code);

    /**
     * @param  id 资源权限ID
     * @param  clientIp 客户端Ip
     * @description 通过数据ID鉴权
     */
    @GetMapping("/auth/data/{id}/authority")
    DataAccessDto dataAuthorityById(@PathVariable(name = "id") String id,
                                    @RequestParam(name = "code", required = false) String code,
                                    @RequestParam(name = "clientIp", required = false) String clientIp);
}
