package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.LogStatisticResDto;
import cn.gtmap.gtc.sso.domain.dto.QueryLogCondition;
import cn.gtmap.gtc.sso.domain.dto.TimeAccessStatsDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/7/29
 * @description
 */

@FeignClient(name="${app.services.log-app:log-app}")
@RequestMapping("/rest/v1/customs")
public interface CustomRecordClient {


    /**
     * @param index: es 索引
     * @param value: value配置值
     * @param keys: 匹配字段列表
     * @return
     * @description 多字段模糊匹配查询
     */
    @GetMapping("/page")
    Page<Map<String,Object>> multiWildcard(Pageable pageable, @RequestParam(name = "index") String index,
                                                  @RequestParam(name = "value") String value,
                                                  @RequestParam(name = "keys") String keys);

    /**
     * @param index: es 索引
     * @param value: value配置值
     * @param keys: 匹配字段列表
     * @return
     * @description 自定义查询
     */
    @PostMapping("/condition/page")
    Page<Map<String,Object>> conditionPage(@RequestParam(name = "pageNumber") int pageNumber,
                                           @RequestParam(name = "pageSize") int pageSize,
                                           @RequestParam(name = "index") String index,
                                           @RequestParam(name = "value", required = false) String value,
                                           @RequestParam(name = "keys", required = false) String keys,
                                           @RequestParam(name = "begin", required = false) Long begin,
                                           @RequestParam(name = "end", required = false) Long end,
                                           @RequestBody(required = false) List<QueryLogCondition> conditions);

    /**
     * @param index: es 索引
     * @param id: 记录ID
     * @param data: 保存的数据
     * @return
     * @description 保存更新记录
     */
    @PostMapping
    void saveOrUpdate(@RequestParam(name = "index") String index,
                             @RequestParam(name = "id") String id,
                             @RequestBody Map<String, Object> data);

    /**
     * @param index: es 索引
     * @param id: 记录ID
     * @return
     * @description 删除记录
     */
    @DeleteMapping
    void delete(@RequestParam(name = "index") String index,
                       @RequestParam(name = "id") String id);


    /**
     * @param index: es 索引
     * @param id: 记录ID
     * @return
     * @description 通过ID查询
     */
    @GetMapping
    Map<String,Object> findById(@RequestParam(name = "index") String index,
                                       @RequestParam(name = "id") String id);

    /**
     * @param index: es 索引
     * @param statisticKeys: 统计的属性
     * @param begin: 开始时间
     * @param end: 结束时间
     * @param conditions: 查询条件
     * @return
     * @description 自定义日志统计接口
     */
    @PostMapping("/statistic")
    List<LogStatisticResDto> statisticLog(
            @RequestParam(name = "index") String index,
            @RequestParam(name = "statisticKeys") String statisticKeys,
            @RequestParam(name = "begin", required = false) Long begin,
            @RequestParam(name = "end", required = false) Long end,
            @RequestBody(required = false) List<QueryLogCondition> conditions);

    /**
     * @param pageNumber: 页码从0开始
     * @param pageSize: 页大小
     * @param index: es 索引
     * @param statisticKeys: 统计的属性
     * @param begin: 开始时间
     * @param end: 结束时间
     * @param conditions: 查询条件
     * @return
     * @description 自定义日志统计接口(分页)
     */
    @PostMapping("/statistic/page")
    public Page<LogStatisticResDto>  statisticLogPage(
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "index") String index,
            @RequestParam(name = "statisticKeys") String statisticKeys,
            @RequestParam(name = "begin", required = false) Long begin,
            @RequestParam(name = "end", required = false) Long end,
            @RequestBody(required = false) List<QueryLogCondition> conditions);
            
    /**
     * 根据时间类型、查询条件统计
     * @param index
     * @param statisticKey
     * @param timeType
     * @param begin
     * @param end
     * @param conditions
     * @return
     */
    @PostMapping("/time/access/statistic")
    List<TimeAccessStatsDto> timeAccessStatistics(
        @RequestParam(name = "index") String index,
        @RequestParam(name = "statisticKey") String statisticKey,
        @RequestParam(name = "timeType", required = false, defaultValue = "day") String timeType,
        @RequestParam(name = "begin", required = false) Long begin,
        @RequestParam(name = "end", required = false) Long end,
        @RequestBody(required = false) List<QueryLogCondition> conditions);
}
