package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-18
 * @description
 */
@FeignClient(name="${app.services.log-app:log-app}")
@RequestMapping("/rest/v1/zipkins")
public interface ZipkinLogClient {

    /**
     * @param id  日志id
     * @return
     * @description 通过日志Id,查询日志信息
     */
    @GetMapping("/{id}")
    AuditLogDto getAuditLogDetail(@PathVariable(name = "id") String id);

    /**
     * @param event     事件
     * @param principal 身份信息
     * @param begin     开始时间
     * @param end       结束时间
     * @return
     * @description 分页查询日志信息
     */
    @GetMapping("/list")
    Page<AuditLogDto> listAuditLogs(Pageable pageable, @RequestParam(name = "event", required = false) String event,
                                    @RequestParam(name = "principal", required = false) String principal,
                                    @RequestParam(name = "begin", required = false) Long begin,
                                    @RequestParam(name = "end", required = false) Long end);

    /**
     * @param event     事件
     * @param principal 身份信息
     * @param classify  日志分类
     * @param begin     开始时间
     * @param end       结束时间
     * @param conditions  查询条件
     * @return
     * @description 自定义条件日志事件分页查询
     */
    @PostMapping("/condition/list")
    Page<AuditLogDto> listLogs(
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "event", required = false) String event,
            @RequestParam(name = "principal", required = false) String principal,
            @RequestParam(name = "classify", required = false) String classify,
            @RequestParam(name = "begin", required = false) Long begin,
            @RequestParam(name = "end", required = false) Long end,
            @RequestBody(required = false) List<QueryLogCondition> conditions);

    /**
     * @param event     事件
     * @param statisticKey 需要统计的字段
     * @param begin     开始时间
     * @param end       结束时间
     * @param conditions  查询条件
     * @return
     * @description 自定义统计
     */
    @PostMapping("/condition/statistic")
    AccessStatsDto statisticLog(@RequestParam(name = "statisticKey") String statisticKey,
                                @RequestParam(name = "event", required = false) String event,
                                @RequestParam(name = "classify", required = false) String classify,
                                @RequestParam(name = "begin", required = false) Long begin,
                                @RequestParam(name = "end", required = false) Long end,
                                @RequestBody(required = false) List<QueryLogCondition> conditions);

    /**
     * @param event     事件
     * @param principal 身份信息
     * @param begin     开始时间
     * @param end       结束时间
     * @return
     * @description 查询系统访问量统计
     */
    @GetMapping("/access-stats")
    AccessStatsDto accessStatistics(@RequestParam(name = "event", required = false) String event,
                                    @RequestParam(name = "principal", required = false) String principal,
                                    @RequestParam(name = "begin", required = false) Long begin,
                                    @RequestParam(name = "end", required = false) Long end);

    /**
     * @param app       应用名称
     * @param event     事件
     * @param principal 身份信息
     * @param begin     开始时间
     * @param end       结束时间
     * @return
     * @description 查询一段时间内，每天的系统访问量统计
     */
    @GetMapping("/day-access-stats")
    List<TimeAccessStatsDto> dayAccessStatistics(
            @RequestParam(name = "app", required = false) String app,
            @RequestParam(name = "event", required = false) String event,
            @RequestParam(name = "principal", required = false) String principal,
            @RequestParam(name = "begin", required = false) Long begin,
            @RequestParam(name = "end", required = false) Long end);


    /**
     * @param query ES 查询json
     * @return
     * @description 通用查询
     */
    @PostMapping("/general-query")
    String generalQuery(@RequestBody String query);

    /**
     * 获取某个应用服务的某个时间段内的峰值
     *
     * @param app
     * @param url
     * @param begin
     * @param end
     * @return
     */
    @GetMapping("/max-access-stats")
    MaxAccessStatsDto maxAccessStatistics(
            @RequestParam(name = "app") String app,
            @RequestParam(name = "url") String url,
            @RequestParam(name = "begin") Long begin,
            @RequestParam(name = "end") Long end);
}
