package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ThirdLoginConfigDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/third-login-config")
public interface ThirdLoginConfigManagerClient {


    @PostMapping
    ThirdLoginConfigDto createThirdLoginConfigure(@RequestBody ThirdLoginConfigDto thirdLoginConfigDto);

    @PutMapping
    ThirdLoginConfigDto updateThirdLoginConfigure(@RequestBody ThirdLoginConfigDto thirdLoginConfigDto);

    @GetMapping("/{id}")
    ThirdLoginConfigDto findById(@PathVariable(name = "id") String id);

    @DeleteMapping("/{id}")
    boolean deleteById(@PathVariable(name = "id") String id);

    @GetMapping("/page")
    Page<ThirdLoginConfigDto> listThirdLoginConfig(Pageable pageable, @RequestParam(name = "code", required = false) String code);
}
