package cn.gtmap.gtc.clients;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FeignClient(name="${app.services.log-app:log-app}")
@RequestMapping("/rest/v1/logs/recover")
public interface LogRecoverClient {
    @PostMapping(value = "/getTreeNodeDatas")
    List getTreeNodeDatas(@RequestParam(name = "pid", required = false) String pid);

    @GetMapping(value = "/getFileByDic")
    List getFileData(@RequestParam(value = "filePath",required = false) String filePath);


    @GetMapping(value = "/recoverLogToES")
    void recoverLogToES(@RequestParam(value = "filePath",required = false) String filePath);

    @GetMapping(value = "/deleteLogs")
    boolean deleteLogs(@RequestParam(value = "filePath",required = false) String filePath);

}
