package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ClientDto;
import cn.gtmap.gtc.sso.domain.dto.ScopeDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/8/3
 * @description
 */
@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/clients")
public interface ClientManagerClient {

    /**
     * @param  clientDto 应用信息
     * @return
     * @description 添加应用
     */
    @PostMapping
    ClientDto createClient(@RequestBody ClientDto clientDto);

    /**
     * @param  id 应用id
     * @return
     * @description 获取应用信息
     */
    @GetMapping("/{id}")
    ClientDto getClientDetail(@PathVariable(name = "id") String id);

    /**
     * @param  clientId 应用编码
     * @return
     * @description 检查应用是否存在
     */
    @GetMapping("/existence")
    Boolean checkExist(@RequestParam("clientId") String clientId);

    /**
     * @param  id 应用id
     * @return
     * @description 更新应用信息
     */
    @PutMapping("/{id}")
    ClientDto updateClientDetail(@PathVariable(name = "id") String id, @RequestBody ClientDto clientDto);

    /**
     * @param  id 应用id
     * @param  scopeIds 资源范围列表
     * @return
     * @description 更新应用Scopes
     */
    @PostMapping("/{id}/scopes")
    Boolean updateClientScopes(@PathVariable(name = "id") String id, @RequestBody List<String> scopeIds);

    /**
     * @param  id 应用id
     * @return
     * @description 获取应用scope列表
     */
    @GetMapping("/{id}/scopes")
    List<ScopeDto> listClientScopes(@PathVariable(name = "id") String id);

    /**
     * @param  id 应用id
     * @return
     * @description 删除应用
     */
    @DeleteMapping("/{id}")
    Boolean deleteClient(@PathVariable(name = "id") String id);

    /**
     * @param  clientId 应用编码
     * @param  name 应用名称
     * @return
     * @description 分页显示应用列表，模糊搜索
     */
    @GetMapping
    Page<ClientDto> listClients(Pageable pageable, @RequestParam(name = "clientId") String clientId, @RequestParam(name = "name") String name);

    /**
     * @param  id 应用id
     * @return
     * @description 启用应用
     */
    @PostMapping("/{id}/enabled")
    Boolean enabled(@PathVariable("id") String id);

    /**
     * @param  id 应用id
     * @return
     * @description 禁用应用
     */
    @PostMapping("/{id}/disabled")
    Boolean disabled(@PathVariable("id") String id);

}
