package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.AuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.OperationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0, 2018/7/7
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/authorities")
public interface AuthorityManagerClient {

    /**
     * @param authorityDto 权限信息
     * @return
     * @description 添加模块权限
     */
    @PostMapping
    AuthorityDto createAuthority(@RequestBody AuthorityDto authorityDto);

    /**
     * @param authorityDto 权限信息
     * @return
     * @description 修改模块权限
     */
    @PutMapping
    AuthorityDto updateAuthority(@RequestBody AuthorityDto authorityDto);

    /**
     * @param  id 权限id
     * @param operationIds 操作id列表
     * @return
     * @description 添加操作权限
     */
    @PatchMapping("/{id}/operation")
    boolean addOperation(@PathVariable(name = "id") String id, @RequestBody List<String> operationIds);

    /**
     * @param  id 权限id
     * @param operationIds 操作id列表
     * @return
     * @description 删除操作权限
     */
    @DeleteMapping("/{id}/operation")
    boolean removeOperationRef(@PathVariable(name = "id") String id, @RequestBody List<String> operationIds);

    /**
     * @param  id 权限id
     * @return
     * @description 根据权限ID删除权限
     */
    @DeleteMapping("/{id}")
    boolean deleteAuthority(@PathVariable(name = "id") String id);

    /**
     * @param  id 权限id
     * @return
     * @description 查看权限信息
     */
    @GetMapping("/{id}")
    AuthorityDto findById(@PathVariable(name = "id") String id);

    /**
     * @param  authorityDto 权限信息
     * @return
     * @description 根据条件查询权限列表
     */
    @PostMapping("/search")
    List<AuthorityDto> findAuthorities(@RequestBody AuthorityDto authorityDto);

    /**
     * @param  username 用户名
     * @param  path 请求路径
     * @param  method GET POST DELETE
     * @return
     * @description 根据条件查询权限列表
     */
    @GetMapping("/url")
    List<AuthorityDto> findUrlAuthorities(@RequestParam(name = "username") String username, @RequestParam(name = "path") String path,
                                          @RequestParam(name = "method", required = false) String method);

    /**
     * @param  username 用户名
     * @param  moduleCode 模块编码
     * @return
     * @description 根据模块CODE获取权限信息
     */
    @GetMapping("module-code")
    List<AuthorityDto> findModuleAuthorities(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode);

    /**
     * @param  username 用户名
     * @param  moduleCode 模块编码
     * @return
     * @description 根据模块CODE获取操作权限列表
     */
    @GetMapping("/module-operations")
    List<OperationDto> findModuleAuthorityOperation(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode);

    /**
     * @param  username 当前操作人
     * @param  clientId 应用Id
     * @param  moduleType 模块类型  classification：业务分类， menu：菜单， form：表单  element：页面元素  api：服务
     * @return
     * @description 根据模块类型获取权限信息
     */
    @GetMapping("/client-modules")
    List<AuthorityDto> findModuleTypeAuthorities(@RequestParam(name = "username") String username, @RequestParam(name = "clientId", required = false) String clientId,
                                                        @RequestParam(name = "moduleType", required = false) String moduleType);

    /**
     * @param  username 当前操作人
     * @param  moduleCode 模块编码
     * @param  moduleType 模块类型  classification：业务分类， menu：菜单， form：表单  element：页面元素  api：服务
     * @return
     * @description 获取子模块下权限列表
     */
    @GetMapping("/sub-module/authorities")
    List<AuthorityDto> findSubModuleAuthorities(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "moduleType") String moduleType);

    /**
     * @param  username 当前操作人
     * @param  clientId 应用Id
     * @return 模块编码串
     * @description 获取登陆人，拥有访问权限的菜单模块编码串
     */

    @GetMapping("/menu-codes")
    String findMenuModules(@RequestParam(name = "username") String username, @RequestParam(name = "clientId", required = false) String clientId);

    /**
     * @param  username 当前操作人
     * @param  clientId 应用Id
     * @return 模块编码串
     * @description 获取用户可访问的模块
     */
    @GetMapping("/client/user/modules")
    List<ModuleDto> findClientUserModules(@RequestParam(name = "username") String username, @RequestParam(name = "clientId") String clientId, @RequestParam(name = "moduleType") String moduleType);


    /**
     * @param  username 当前操作人
     * @param  moduleCode 上一级模块编码
     * @return 模块编码串
     * @description 获取当前模块下级可访问模块列表
     */
    @GetMapping("/sub/user/modules")
    List<ModuleDto> findSubUserModules(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "moduleType") String moduleType);


    /**
     * @param  username 当前操作人
     * @param  moduleCode 模块编码
     * @return 角色列表
     * @description 根据模块查询有权限访问的角色列表
     */
    @GetMapping("/module/roles")
    List<RoleDto> hasAuthRoles(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode);

}
