package cn.gtmap.estateplat.model.exchange.share;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
 * @version 1.0, 2025/11/13
 * @description 共享外网创建指派创建人表
 */
@Table(name = "GX_WW_ZPCJR")
public class GxWwZpcjr implements Serializable {

    /**
     * 外网申请受理编号（对应字段：SQSLBH）
     */
    @Id
    private String sqslbh;
    /**
     * 指派时间（对应字段：ZPSJ）
     */
    private Date zpsj;

    /**
     * 指派人用户id（对应字段：ZPRID）
     */
    private String zprid;

    /**
     * 创建人id（对应字段：CJRID）
     */
    private String cjrid;

    /**
     * 创建人名称（对应字段：CJRMB）
     */
    private String cjrmc;

    public String getSqslbh() {
        return sqslbh;
    }

    public void setSqslbh(String sqslbh) {
        this.sqslbh = sqslbh;
    }


    public Date getZpsj() {
        return zpsj;
    }

    public void setZpsj(Date zpsj) {
        this.zpsj = zpsj;
    }

    public String getZprid() {
        return zprid;
    }

    public void setZprid(String zprid) {
        this.zprid = zprid;
    }

    public String getCjrid() {
        return cjrid;
    }

    public void setCjrid(String cjrid) {
        this.cjrid = cjrid;
    }

    public String getCjrmc() {
        return cjrmc;
    }

    public void setCjrmc(String cjrmc) {
        this.cjrmc = cjrmc;
    }
}
