package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleFourAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 土地所有权
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_QL_TDSYQ")
@Table(name = "QLF_QL_TDSYQ")
public class QlfQlTdsyqNew implements Serializable, AccessData {
    final static String ysdm = "6002010100";//要素代码
    private String zddm;//宗地代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String qllx;//权利类型
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String mjdw;//面积单位
    private Double nydmj;//农用地面积
    private Double gdmj;//耕地面积
    private Double ldmj;//林地面积
    private Double cdmj;//草地面积
    private Double qtnydmj;//其他农用地面积
    private Double jsydmj;//建设用地面积
    private Double wlydmj;//未利用地面积
    private String bdcqzh;//不动产权证号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    private String ssywh;//上手业务号
    private String yt;//土地用途
    @XmlAttribute(name = "SSYWH")
    public String getSsywh() {
        return ssywh;
    }

    public void setSsywh(String ssywh) {
        this.ssywh = ssywh;
    }
    @XmlAttribute(name = "YT")
    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "ZDDM")
    public String getZddm() {
        return zddm;
    }

    public void setZddm(String zddm) {
        this.zddm = zddm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "QLLX")
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "MJDW")
    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    @XmlAttribute(name = "NYDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getNydmj() {
        return nydmj;
    }

    public void setNydmj(Double nydmj) {
        this.nydmj = nydmj;
    }

    @XmlAttribute(name = "GDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getGdmj() {
        return gdmj;
    }

    public void setGdmj(Double gdmj) {
        this.gdmj = gdmj;
    }

    @XmlAttribute(name = "LDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getLdmj() {
        return ldmj;
    }

    public void setLdmj(Double ldmj) {
        this.ldmj = ldmj;
    }

    @XmlAttribute(name = "CDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getCdmj() {
        return cdmj;
    }

    public void setCdmj(Double cdmj) {
        this.cdmj = cdmj;
    }

    @XmlAttribute(name = "QTNYDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getQtnydmj() {
        return qtnydmj;
    }

    public void setQtnydmj(Double qtnydmj) {
        this.qtnydmj = qtnydmj;
    }

    @XmlAttribute(name = "JSYDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getJsydmj() {
        return jsydmj;
    }

    public void setJsydmj(Double jsydmj) {
        this.jsydmj = jsydmj;
    }

    @XmlAttribute(name = "WLYDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getWlydmj() {
        return wlydmj;
    }

    public void setWlydmj(Double wlydmj) {
        this.wlydmj = wlydmj;
    }

    @XmlAttribute(name = "BDCQZH")
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }


}
