package cn.gtmap.estateplat.model.acceptance;/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2018/10/22
 * @description 
 */

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @Description: 收费单
 * @Date 13:19 2018/10/22
 */
@Entity
@Table(name = "YCSL_SFD")
public class YcslSfd implements Serializable {
    /**
     * 收费ID
     */
    @Column(name = "SFID")
    @Id
    private String sfid;
    /**
     * 项目id
     */
    @Column(name = "PROID")
    private String proid;
    /**
     * 计费基数
     */
    @Column(name = "JFJS")
    private Integer jfjs;
    /**
     * 比例
     */
    @Column(name = "JFBL")
    private Double jfbl;
    /**
     * 实收金额
     */
    @Column(name = "SSJE")
    private Double ssje;
    /**
     * 收款方
     */
    @Column(name = "SKF")
    private String skf;
    /**
     * 二维码
     */
    @Column(name = "EWM")
    private String ewm;
    /**
     * 土地缴纳金
     */
    @Column(name = "TDJNJ")
    private Double tdjnj;

    /**
     * 费用名称
     */
    @Column(name = "FYMC")
    private String fymc;

    /**
     * 收费日期
     */
    @Column(name = "SFRQ")
    private Date sfrq;

    /**
     * 土地缴纳金流水号
     */
    @Column(name = "TDJNJLSH")
    private String tdjnjlsh;
    /**
     * 收费确认
     */
    @Column(name = "SFQR")
    private String sfqr;

    /**
     * 抵押缴款方
     */
    @Column(name = "DYJKF")
    private String dyjkf;
    /**
     * 抵押登记费
     */
    @Column(name = "DYDJF")
    private Double dydjf;
    /**
     * 抵押登记费二维码
     */
    @Column(name = "DYDJFEWM")
    private String dydjfewm;


    public String getSfid() {
        return sfid;
    }

    public void setSfid(String sfid) {
        this.sfid = sfid;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Integer getJfjs() {
        return jfjs;
    }

    public void setJfjs(Integer jfjs) {
        this.jfjs = jfjs;
    }

    public Double getJfbl() {
        return jfbl;
    }

    public void setJfbl(Double jfbl) {
        this.jfbl = jfbl;
    }

    public Double getSsje() {
        return ssje;
    }

    public void setSsje(Double ssje) {
        this.ssje = ssje;
    }

    public String getSkf() {
        return skf;
    }

    public void setSkf(String skf) {
        this.skf = skf;
    }

    public String getEwm() {
        return ewm;
    }

    public void setEwm(String ewm) {
        this.ewm = ewm;
    }

    public Double getTdjnj() {
        return tdjnj;
    }

    public void setTdjnj(Double tdjnj) {
        this.tdjnj = tdjnj;
    }

    public String getFymc() {
        return fymc;
    }

    public void setFymc(String fymc) {
        this.fymc = fymc;
    }

    public Date getSfrq() {
        return sfrq;
    }

    public void setSfrq(Date sfrq) {
        this.sfrq = sfrq;
    }

    public String getTdjnjlsh() {
        return tdjnjlsh;
    }

    public void setTdjnjlsh(String tdjnjlsh) {
        this.tdjnjlsh = tdjnjlsh;
    }

    public String getSfqr() {
        return sfqr;
    }

    public void setSfqr(String sfqr) {
        this.sfqr = sfqr;
    }

    public String getDyjkf() {
        return dyjkf;
    }

    public void setDyjkf(String dyjkf) {
        this.dyjkf = dyjkf;
    }

    public Double getDydjf() {
        return dydjf;
    }

    public void setDydjf(Double dydjf) {
        this.dydjf = dydjf;
    }

    public String getDydjfewm() {
        return dydjfewm;
    }

    public void setDydjfewm(String dydjfewm) {
        this.dydjfewm = dydjfewm;
    }
}
