package cn.gtmap.estateplat.model.acceptance;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * @author <a href="mailto:chengong@gtmap.cn">chengong</a>
 * @version 1.0, 2020/12/31
 * @description 收费项目配置
 */
@Entity
@Table ( name ="YCSL_XT_SFXM" )
public class YcslXtSfxm implements Serializable {

	private static final long serialVersionUID = -8560847019149305578L;

	/**
	 * 收费项目序号
	 */
   	@Column(name = "SFXMID" )
	 @Id
	private String sfxmid;

	/**
	 * 收费项目名称
	 */
   	@Column(name = "SFXMMC" )
	private String sfxmmc;

	/**
	 * 收费项目标准
	 */
   	@Column(name = "SFXMBZ" )
	private String sfxmbz;

	/**
	 * 默认数量
	 */
   	@Column(name = "MRSL" )
	private Integer mrsl;

	/**
	 * 单位
	 */
   	@Column(name = "DW" )
	private String dw;

	/**
	 * 金额
	 */
   	@Column(name = "JE" )
	private Double je;

	/**
	 * 申请类型代码
	 */
   	@Column(name = "SQLXDM" )
	private String sqlxdm;

	/**
	 * 是否默认设置（1：默认，0：非默认）
	 */
   	@Column(name = "SFMRSZ" )
	private String sfmrsz;

	/**
	 * 计算方法
	 */
   	@Column(name = "JSFF" )
	private String jsff;

	/**
	 * 权利人类型
	 */
   	@Column(name = "QLRLX" )
	private String qlrlx;

	/**
	 * 收费项目代码
	 */
   	@Column(name = "SFXMDM" )
	private String sfxmdm;

	/**
	 * 房屋用途
	 */
	@Column(name = "FWYT" )
	private String fwyt;

	/**
	 * 不动产收费项目名称
	 */
	@Column(name = "BDCSFXMMC" )
	private String bdcsfxmmc;

	/**
	 * 用途
	 */
	@Column(name = "YT" )
	private String yt;

	public String getSfxmid() {
		return sfxmid;
	}

	public void setSfxmid(String sfxmid) {
		this.sfxmid = sfxmid;
	}

	public String getSfxmmc() {
		return sfxmmc;
	}

	public void setSfxmmc(String sfxmmc) {
		this.sfxmmc = sfxmmc;
	}

	public String getSfxmbz() {
		return sfxmbz;
	}

	public void setSfxmbz(String sfxmbz) {
		this.sfxmbz = sfxmbz;
	}

	public Integer getMrsl() {
		return mrsl;
	}

	public void setMrsl(Integer mrsl) {
		this.mrsl = mrsl;
	}

	public String getDw() {
		return dw;
	}

	public void setDw(String dw) {
		this.dw = dw;
	}

	public Double getJe() {
		return je;
	}

	public void setJe(Double je) {
		this.je = je;
	}

	public String getSqlxdm() {
		return sqlxdm;
	}

	public void setSqlxdm(String sqlxdm) {
		this.sqlxdm = sqlxdm;
	}

	public String getSfmrsz() {
		return sfmrsz;
	}

	public void setSfmrsz(String sfmrsz) {
		this.sfmrsz = sfmrsz;
	}

	public String getJsff() {
		return jsff;
	}

	public void setJsff(String jsff) {
		this.jsff = jsff;
	}

	public String getQlrlx() {
		return qlrlx;
	}

	public void setQlrlx(String qlrlx) {
		this.qlrlx = qlrlx;
	}

	public String getSfxmdm() {
		return sfxmdm;
	}

	public void setSfxmdm(String sfxmdm) {
		this.sfxmdm = sfxmdm;
	}

	public String getFwyt() {
		return fwyt;
	}

	public void setFwyt(String fwyt) {
		this.fwyt = fwyt;
	}

	public String getBdcsfxmmc() {
		return bdcsfxmmc;
	}

	public void setBdcsfxmmc(String bdcsfxmmc) {
		this.bdcsfxmmc = bdcsfxmmc;
	}

	public String getYt() {
		return yt;
	}

	public void setYt(String yt) {
		this.yt = yt;
	}
}
