package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDoubleFourAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 土地承包经营权登记信息（耕地等农用地）附记
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_QL_TDCBJYQFJ")
@Table(name = "QLF_QL_TDCBJYQFJ")
public class QlfQlTdcbjyqfj implements Serializable, AccessData {
    private String htdm;//合同代码
    private Double ycbhtmj;//原承包合同面积
    private Double cbdqqhtzmj;//承包地确权（合同）总面积
    private Integer cbdqqdkzs;//承包地确权地块总数
    private String cbdbdcdydm;//承包地不动产单元代码
    private Date updatetime;
    private Date createtime;

    @XmlAttribute(name = "HTDM")
    public String getHtdm() {
        return htdm;
    }

    public void setHtdm(String htdm) {
        this.htdm = htdm;
    }

    @XmlAttribute(name = "YCBHTMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getYcbhtmj() {
        return ycbhtmj;
    }

    public void setYcbhtmj(Double ycbhtmj) {
        this.ycbhtmj = ycbhtmj;
    }

    @XmlAttribute(name = "CBDQQHTZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getCbdqqhtzmj() {
        return cbdqqhtzmj;
    }

    public void setCbdqqhtzmj(Double cbdqqhtzmj) {
        this.cbdqqhtzmj = cbdqqhtzmj;
    }

    @XmlAttribute(name = "CBDQQDKZS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getCbdqqdkzs() {
        return cbdqqdkzs;
    }

    public void setCbdqqdkzs(Integer cbdqqdkzs) {
        this.cbdqqdkzs = cbdqqdkzs;
    }

    @XmlAttribute(name = "CBDBDCDYDM")
    public String getCbdbdcdydm() {
        return cbdbdcdydm;
    }

    public void setCbdbdcdydm(String cbdbdcdydm) {
        this.cbdbdcdydm = cbdbdcdydm;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
}
