package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleFourAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 土地承包经营权
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_QL_TDCBJYQ")
@Table(name = "QLF_QL_TDCBJYQ")
public class QlfQlTdcbjyq implements Serializable, AccessData {
    final static String ysdm = "6002020400";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String dkbm;//地块代码
    private String dkmc;//地块名称
    private String qllx;//权利类型
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String fbfbm;//发包方代码
    private String fbfqc;//发包方全称
    private String fbffzr;//发包方负责人
    private String cbfs;//承包方式
    private Double qqmj;//确权（合同）面积
    private Date cbqssj;//承包(使用)起始时间
    private Date cbjssj;//承包(使用)结束时间
    private String cbqx;//承包期限
    private String tdsyqxz;//土地所有权性质
    private String yt;//土地用途
    private String ydyhfl;//用地用海分类
    private String htdm;//合同代码
    private String bdcqzh;//不动产权证号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    private String sfyjjbnt;//是否永久基本农田
    private String cbjyqqdfs;//承包经营权取得方式
    private String sfzld;//是否自留地
    private String sfqqqg;//是否确权确股
    private String bz;//备注
    /**
     * 插入更新时间
     *
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**
     * 插入创建时间
     *
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "DKBM")
    public String getDkbm() {
        return dkbm;
    }

    public void setDkbm(String dkbm) {
        this.dkbm = dkbm;
    }

    @XmlAttribute(name = "DKMC")
    public String getDkmc() {
        return dkmc;
    }

    public void setDkmc(String dkmc) {
        this.dkmc = dkmc;
    }

    @XmlAttribute(name = "QLLX")
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "FBFBM")
    public String getFbfbm() {
        return fbfbm;
    }

    public void setFbfbm(String fbfbm) {
        this.fbfbm = fbfbm;
    }

    @XmlAttribute(name = "FBFQC")
    public String getFbfqc() {
        return fbfqc;
    }

    public void setFbfqc(String fbfqc) {
        this.fbfqc = fbfqc;
    }

    @XmlAttribute(name = "FBFFZR")
    public String getFbffzr() {
        return fbffzr;
    }

    public void setFbffzr(String fbffzr) {
        this.fbffzr = fbffzr;
    }

    @XmlAttribute(name = "CBFS")
    public String getCbfs() {
        return cbfs;
    }

    public void setCbfs(String cbfs) {
        this.cbfs = cbfs;
    }

    @XmlAttribute(name = "QQMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getQqmj() {
        return qqmj;
    }

    public void setQqmj(Double qqmj) {
        this.qqmj = qqmj;
    }

    @XmlAttribute(name = "CBQSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getCbqssj() {
        return cbqssj;
    }

    public void setCbqssj(Date cbqssj) {
        this.cbqssj = cbqssj;
    }

    @XmlAttribute(name = "CBJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getCbjssj() {
        return cbjssj;
    }

    public void setCbjssj(Date cbjssj) {
        this.cbjssj = cbjssj;
    }

    @XmlAttribute(name = "CBQX")
    public String getCbqx() {
        return cbqx;
    }

    public void setCbqx(String cbqx) {
        this.cbqx = cbqx;
    }

    @XmlAttribute(name = "TDSYQXZ")
    public String getTdsyqxz() {
        return tdsyqxz;
    }

    public void setTdsyqxz(String tdsyqxz) {
        this.tdsyqxz = tdsyqxz;
    }

    @XmlAttribute(name = "YT")
    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    @XmlAttribute(name = "YDYHFL")
    public String getYdyhfl() {
        return ydyhfl;
    }

    public void setYdyhfl(String ydyhfl) {
        this.ydyhfl = ydyhfl;
    }

    @XmlAttribute(name = "HTDM")
    public String getHtdm() {
        return htdm;
    }

    public void setHtdm(String htdm) {
        this.htdm = htdm;
    }

    @XmlAttribute(name = "BDCQZH")
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }


    @XmlAttribute(name = "SFYJJBNT")
    public String getSfyjjbnt() {
        return sfyjjbnt;
    }

    public void setSfyjjbnt(String sfyjjbnt) {
        this.sfyjjbnt = sfyjjbnt;
    }

    @XmlAttribute(name = "CBJYQQDFS")
    public String getCbjyqqdfs() {
        return cbjyqqdfs;
    }

    public void setCbjyqqdfs(String cbjyqqdfs) {
        this.cbjyqqdfs = cbjyqqdfs;
    }

    @XmlAttribute(name = "SFZLD")
    public String getSfzld() {
        return sfzld;
    }

    public void setSfzld(String sfzld) {
        this.sfzld = sfzld;
    }

    @XmlAttribute(name = "SFQQQG")
    public String getSfqqqg() {
        return sfqqqg;
    }

    public void setSfqqqg(String sfqqqg) {
        this.sfqqqg = sfqqqg;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
}
