/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.utils.AppConfigPlaceholderConfigurer;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DESPlus {
    private static Logger logger = Logger.getLogger(AppConfigPlaceholderConfigurer.class);
    private static String strDefaultKey = "cn.gtmap.bs4.analysis";
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public DESPlus() {
        this(strDefaultKey);
    }

    public DESPlus(String strKey) {
        Key key = null;
        try {
            key = this.getKey(strKey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        try {
            this.encryptCipher = Cipher.getInstance("DES");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        try {
            this.encryptCipher.init(1, key);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        try {
            this.decryptCipher = Cipher.getInstance("DES");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        try {
            this.decryptCipher.init(2, key);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
    }

    public static String byteArr2HexStr(byte[] arrB) {
        int iLen = arrB.length;
        StringBuilder sb = new StringBuilder(iLen * 2);
        for (int i = 0; i < iLen; ++i) {
            int intTmp;
            for (intTmp = arrB[i]; intTmp < 0; intTmp += 256) {
            }
            if (intTmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intTmp, 16));
        }
        return sb.toString();
    }

    public static byte[] hexStr2ByteArr(String strIn) {
        byte[] arrB = new byte[]{};
        try {
            arrB = strIn.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        int iLen = arrB.length;
        byte[] arrOut = new byte[iLen / 2];
        for (int i = 0; i < iLen; i += 2) {
            String strTmp = null;
            try {
                strTmp = new String(arrB, i, 2, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"msg", (Throwable)e);
            }
            arrOut[i / 2] = (byte)Integer.parseInt(strTmp, 16);
        }
        return arrOut;
    }

    public byte[] encrypt(byte[] arrB) {
        byte[] bytes = new byte[]{};
        try {
            bytes = this.encryptCipher.doFinal(arrB);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        return bytes;
    }

    public String encrypt(String strIn) {
        String result;
        try {
            result = DESPlus.byteArr2HexStr(this.encrypt(strIn.getBytes("UTF-8")));
        }
        catch (Exception e) {
            logger.error((Object)"msg", (Throwable)e);
            throw new AppException(e);
        }
        return result;
    }

    public byte[] decrypt(byte[] arrB) {
        byte[] byte1 = null;
        try {
            byte1 = this.decryptCipher.doFinal(arrB);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)"msg", (Throwable)e);
        }
        return byte1;
    }

    public String decrypt(String strIn) {
        if (strIn != null) {
            try {
                return new String(this.decrypt(DESPlus.hexStr2ByteArr(strIn)), "UTF-8");
            }
            catch (Exception e) {
                logger.error((Object)"msg", (Throwable)e);
            }
        }
        return null;
    }

    private Key getKey(byte[] arrBTmp) {
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        return new SecretKeySpec(arrB, "DES");
    }

    public static void main(String[] args) {
        try {
            DESPlus desplus = new DESPlus();
            if (StringUtils.isNotBlank((CharSequence)desplus.encrypt("gtis"))) {
                logger.info((Object)desplus.encrypt("gtis"));
            } else {
                logger.info((Object)"null");
            }
        }
        catch (Exception e) {
            logger.error((Object)"msg", (Throwable)e);
        }
    }
}

