package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.text.DecimalFormat;

/**
 * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
 * @version 1.0, 2024/1/19
 * @description 携带默认值的Double三位小数适配器
 */
public class JaxbDoubleThreeDefaultAdapter extends XmlAdapter<String, Double> {

    @Override
    public Double unmarshal(String v) throws Exception {
        if(StringUtils.isNoneBlank(v)){
            return Double.parseDouble(v);
        }
        return null;
    }

    @Override
    public String marshal(Double v) throws Exception {
        String str = "0.000";
        if (v != null) {
            DecimalFormat df = new DecimalFormat("0.000");
            str = df.format(v);
        }
        return str;
    }
}
