package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Date;

/**
 * 土地经营权登记信息（耕地等农用地）的关联关系
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_QL_TDCBJYQGLGX")
@Table(name = "QLF_QL_TDCBJYQGLGX")
public class QlfQlTdcbjyqglgxNew implements Serializable, AccessData {
    private String tdjyqywh;//土地经营权业务号
    private String tdjyqdyh;//土地经营权不动产单元号
    private String tdjyqzh;//土地经营权不动产权证号
    private String tdcbjyqywh;//土地承包经营权（土地经营权）业务号
    private String tdcbjyqdyh;//土地承包经营权（土地经营权）不动产单元号
    private String tdcbjyqzh;//土地承包经营权（土地经营权）不动产权证号
    private Date updatetime;
    private Date createtime;

    @XmlAttribute(name = "TDJYQYWH")
    public String getTdjyqywh() {
        return tdjyqywh;
    }

    public void setTdjyqywh(String tdjyqywh) {
        this.tdjyqywh = tdjyqywh;
    }

    @XmlAttribute(name = "TDJYQDYH")
    public String getTdjyqdyh() {
        return tdjyqdyh;
    }

    public void setTdjyqdyh(String tdjyqdyh) {
        this.tdjyqdyh = tdjyqdyh;
    }

    @XmlAttribute(name = "TDJYQZH")
    public String getTdjyqzh() {
        return tdjyqzh;
    }

    public void setTdjyqzh(String tdjyqzh) {
        this.tdjyqzh = tdjyqzh;
    }

    @XmlAttribute(name = "TDCBJYQYWH")
    public String getTdcbjyqywh() {
        return tdcbjyqywh;
    }

    public void setTdcbjyqywh(String tdcbjyqywh) {
        this.tdcbjyqywh = tdcbjyqywh;
    }

    @XmlAttribute(name = "TDCBJYQDYH")
    public String getTdcbjyqdyh() {
        return tdcbjyqdyh;
    }

    public void setTdcbjyqdyh(String tdcbjyqdyh) {
        this.tdcbjyqdyh = tdcbjyqdyh;
    }

    @XmlAttribute(name = "TDCBJYQZH")
    public String getTdcbjyqzh() {
        return tdcbjyqzh;
    }

    public void setTdcbjyqzh(String tdcbjyqzh) {
        this.tdcbjyqzh = tdcbjyqzh;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
}
