package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbStringNoNullAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2022年04月19日
 * @description 当日上报详单
 */
@XmlType(name = "access", propOrder = {"bwid", "ywh","bdcdyh"})
@XmlRootElement(name = "Access")
public class Access {
    private String bwid;//报文ID
    private String ywh;//业务号
    private String bdcdyh;//不动产单元号

    @XmlAttribute(name = "BWID")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getBwid() {
        return bwid;
    }

    public void setBwid(String bwid) {
        this.bwid = bwid;
    }
    @XmlAttribute(name = "YWH")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }
    @XmlAttribute(name = "BDCDYH")
    @XmlJavaTypeAdapter(JaxbStringNoNullAdapter.class)
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }
}
