package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.AliyunSmsService;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.BatchSmsAttributes;
import com.aliyun.mns.model.MessageAttributes;
import com.aliyun.mns.model.RawTopicMessage;
import com.aliyun.mns.model.TopicMessage;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import java.util.Map;

/**
 * .
 *
 * @version 1.0 2017/5/17
 * @author: bianwen
 * @description 阿里云短信服务
 */
public class AliyunSmsServiceImpl implements AliyunSmsService {
    private static final String PHONE_NUMBER_NULL="电话号码为空！";
    private static final String CONTENT_NUMBER_NULL="短信内容为空！";
    private static final String ALI_ACCOUNT_NULL="阿里云账号为空！";
    private static final String ALI_ACCOUNT_KEY_NULL="阿里云账号秘钥为空！";
    private static final String ENDPOINT_NULL="MNS的接入地址为空！";
    private static final String TOPICNAME_NULL="主题名称为空！";
    private static final String SIGNNAME_NULL="短信签名名称为空！";

    private String accessId;  //阿里账户id
    private String accessKey; //阿里账户key
    private String endpoint;  //公网地址
    private String topicName;  //主题名称
    private String signName;  //短信签名名称
    private String smsCode;// 短信模板

    public String getAccessId() {
        return accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getTopicName() {
        return topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getSmsCode() {
        return smsCode;
    }

    public void setSmsCode(String smsCode) {
        this.smsCode = smsCode;
    }



    /**
     * @author bianwen
     * @description
     * @param paramMap(短信内容参数)
     * @param receiveNum(短信接收号码)
     */
    public void sendSms(Map<String,String> paramMap,String receiveNum){
        if(StringUtils.isBlank(receiveNum))
            throw new AppException(PHONE_NUMBER_NULL);
        if(StringUtils.isBlank(smsCode)){
            throw new AppException(CONTENT_NUMBER_NULL);
        }
        if(StringUtils.isBlank(accessId)){
            throw new AppException(ALI_ACCOUNT_NULL);
        }
        if(StringUtils.isBlank(accessKey)){
            throw new AppException(ALI_ACCOUNT_KEY_NULL);
        }
        if(StringUtils.isBlank(endpoint)){
            throw new AppException(ENDPOINT_NULL);
        }
        if(StringUtils.isBlank(topicName)){
            throw new AppException(TOPICNAME_NULL);
        }
        if(StringUtils.isBlank(signName)){
            throw new AppException(SIGNNAME_NULL);
        }


        /**
         * Step 1. 获取主题引用
         */
        CloudAccount account = new CloudAccount(accessId, accessKey, endpoint);
        MNSClient client = account.getMNSClient();
        CloudTopic topic = client.getTopicRef(topicName);
        /**
         * Step 2. 设置SMS消息体（必须）
         *
         * 注：目前暂时不支持消息内容为空，需要指定消息内容，不为空即可。
         */
        RawTopicMessage msg = new RawTopicMessage();
        msg.setMessageBody("sms-message");
        /**
         * Step 3. 生成SMS消息属性
         */
        MessageAttributes messageAttributes = new MessageAttributes();
        BatchSmsAttributes batchSmsAttributes = new BatchSmsAttributes();
        // 3.1 设置发送短信的签名（SMSSignName）
        batchSmsAttributes.setFreeSignName(signName);
        // 3.2 设置发送短信使用的模板（SMSTempateCode）
        batchSmsAttributes.setTemplateCode(smsCode);
        // 3.3 设置发送短信所使用的模板中参数对应的值（在短信模板中定义的，没有可以不用设置）
        BatchSmsAttributes.SmsReceiverParams smsReceiverParams = new BatchSmsAttributes.SmsReceiverParams();
        if(MapUtils.isNotEmpty(paramMap)){
            for (String key : paramMap.keySet()) {
                smsReceiverParams.setParam(key, (String) paramMap.get(key));
            }
        }

        // 3.4 增加接收短信的号码
        batchSmsAttributes.addSmsReceiver(receiveNum, smsReceiverParams);
        messageAttributes.setBatchSmsAttributes(batchSmsAttributes);
        try {
            /**
             * Step 4. 发布SMS消息
             */
            TopicMessage ret = topic.publishMessage(msg, messageAttributes);
            System.out.println("MessageId: " + ret.getMessageId());
            System.out.println("MessageMD5: " + ret.getMessageBodyMD5());
        } catch (ServiceException se) {
            System.out.println(se.getErrorCode() + se.getRequestId());
            System.out.println(se.getMessage());
            se.printStackTrace();
            throw new AppException(se.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new AppException(e.getMessage());
        }
        client.close();

    }
}
