package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDoubleTwoAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 界址线信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTT_GY_JZX")
@Table(name = "KTT_GY_JZX")
public class KttGyJzxNew implements Serializable, AccessData {
    final static String ysdm = "6001060000";//要素代码
    private Integer bsm;//标识码
    private String zdzhdm;//宗地宗海代码
    private Double jzxcd;//界址线长度
    private String jzxlb;//界址线类别
    private String jzxwz;//界址线位置
    private String jxxz;//界线性质
    private String qsjxxysbh;//权属界线协议书编码
    private String qsjxxys;//权属界线协议书
    private String qszyyysbh;//权属争议原由书编码
    private String qszyyys;//权属争议原由书
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "QSJXXYBH")
    public String getQsjxxysbh() {
        return qsjxxysbh;
    }

    public void setQsjxxysbh(String qsjxxysbh) {
        this.qsjxxysbh = qsjxxysbh;
    }

    @XmlAttribute(name = "QSZYYYSBH")
    public String getQszyyysbh() {
        return qszyyysbh;
    }

    public void setQszyyysbh(String qszyyysbh) {
        this.qszyyysbh = qszyyysbh;
    }

    @XmlAttribute(name = "BSM")
    public Integer getBsm() {
        return bsm;
    }

    public void setBsm(Integer bsm) {
        this.bsm = bsm;
    }

    @XmlAttribute(name = "ZDZHDM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdzhdm() {
        return zdzhdm;
    }

    public void setZdzhdm(String zdzhdm) {
        this.zdzhdm = zdzhdm;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "JZXCD")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getJzxcd() {
        return jzxcd;
    }

    public void setJzxcd(Double jzxcd) {
        this.jzxcd = jzxcd;
    }

    @XmlAttribute(name = "JZXLB")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJzxlb() {
        return jzxlb;
    }

    public void setJzxlb(String jzxlb) {
        this.jzxlb = jzxlb;
    }

    @XmlAttribute(name = "JZXWZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJzxwz() {
        return jzxwz;
    }

    public void setJzxwz(String jzxwz) {
        this.jzxwz = jzxwz;
    }

    @XmlAttribute(name = "JXXZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJxxz() {
        return jxxz;
    }

    public void setJxxz(String jxxz) {
        this.jxxz = jxxz;
    }

    @XmlAttribute(name = "QSJXXYS")
    public String getQsjxxys() {
        return qsjxxys;
    }

    public void setQsjxxys(String qsjxxys) {
        this.qsjxxys = qsjxxys;
    }

    @XmlAttribute(name = "QSZYYYS")
    public String getQszyyys() {
        return qszyyys;
    }

    public void setQszyyys(String qszyyys) {
        this.qszyyys = qszyyys;
    }
}
