package cn.gtmap.estateplat.core.support.freemarker.method;

import cn.gtmap.estateplat.core.support.freemarker.FmUtils;
import cn.gtmap.estateplat.utils.RequestUtils;
import com.google.common.collect.Maps;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;

import java.util.List;
import java.util.Map;

/**
 * url函数,支持以下语法:
 * ${_url('/user',"p1","v1", "p2","v2")}
 * ${_url('/user',"p1","v1", "p2")}
 * ${_url('user',"p1","v1", "p2",["v21","v22"])}
 * ${_url('/item',{"name":"mouse", "price":50})}
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-25
 */
public class UrlMethod implements TemplateMethodModelEx {
    @Override
    public Object exec(List args) throws TemplateModelException {
        int len = args.size();
        switch (len) {
            case 0:
                return RequestUtils.buildUrl(null, null);
            case 1:
                return RequestUtils.buildUrl(args.get(0).toString(), null);
            default:
                Map<Object, Object> map = Maps.newHashMap();
                for (int i = 1; i < len; i += 2) {
                    Object key = args.get(i);
                    if (key instanceof TemplateHashModel) {
                        map.putAll(FmUtils.<Map>unwrap(key));
                        break;
                    }
                    if (i < len - 1) {
                        map.put(key, FmUtils.unwrap(args.get(i + 1)));
                    } else {
                        map.put(key, null);
                    }
                }
                return RequestUtils.buildUrl(args.get(0).toString(), map);
        }
    }
}
