package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2022年06月20日
 * @description
 */
public class JaxbNotNullIntegerAdapter extends XmlAdapter<String, Integer> {
    @Override
    public Integer unmarshal(String s) throws Exception {
        if(StringUtils.isNoneBlank(s)){
            return Integer.parseInt(s);
        }
        return null;
    }

    @Override
    public String marshal(Integer integer) throws Exception {
        String str = "";
        if (integer != null) {
            str = integer.toString();
        }
        return str;
    }
}
