package cn.gtmap.estateplat.model.server.core;

import cn.gtmap.sdk.mybatis.plugin.annotation.Crypt;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 不动产登记项目
 *
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/11/1
 */
@Data
@Entity
@Table(name = "bdc_xm")
public class BdcXm implements Xmxx, Serializable, InsertVo, BdcProid {
    @Id
    @Column
    private String proid;//项目id
    @Column
    private String bh;//编号
    @Column
    private String qllx;//权力类型
    @Column
    private String djlx;//登记类型
    @Column
    private String djyy;//登记原因
    @Column
    private String sqzsbs;//申请证书板式
    @Column
    private String sqfbcz;//申请分别持证
    @Column
    private String bz; //备注
    @Column
    private String sqrsm;//申请人说明
    @Column
    private String xmzt;//项目状态
    @Column
    private String dwdm;//单位代码
    @Column
    private Date cjsj;//创建时间
    @Column
    private String cjr;//创建人
    @Column
    private String xmly;//项目来源
    @Column
    private Date bjsj;//办结时间
    @Column
    private String lsh;//流水号
    @Column
    private String nf;//年份
    @Column
    private String xmmc;//项目名称
    @Column
    private String sqlx;//申请类型
    @Column
    private String bdcdyid;//不动产单元ID
    @Column
    private String djsy;//登记事由
    @Column
    private String dydjlx;//抵押登记类型
    @Column
    private String bdclx;//不动产类型
    @Column
    private String zl;//坐落
    @Column
    private String ybdcqzh;//原不动产权证号
    @Column
    private String ybh;//原受理编号
    @Column
    private String blyzh;//是否继承原证号
    @Column
    private String djzx;//登记子项
    @Column
    private String wiid;//工作流id
    @Column
    private String sfydbj;//是否异地办件
    @Column
    private String ssxz;//所属乡镇
    @Column
    private String spxtywh;//审批系统业务号
    @Column
    private String cqgs;//产权归属
    @Column
    private String yfczh;//原房产证号
    @Column
    private String ytdzh;//原土地证号
    @Column
    private Date lzrq;//领证日期
    @Column
    private String lzr;//领证人
    @Column
    private String xnbh;//虚拟编号
    @Column
    private String ydh;//用电号
    @Column
    private String lclb;//流程类别
    @Column
    private String ywly;//业务来源(ycsl:一窗；bdcdj:登记)
    @Column
    private String sfjzzy;//是否禁止转移(1:是;2:否)
    @Column
    private String ycsjd;//一窗收件单：（sp：商品房 cl:存量房）
    @Column
    private String zyyd;//不动产转移约定(0:占份额三分之二以上的按份共有人;1:全体共同共有人同意)
    @Column
    private String djfs;//登记方式:1:依申请;2:依职权;3:依嘱托
    @Column
    private String xmbs;//项目标识
    @Column
    private String sftqsczs;//是否提前生成证书
    @Column
    private String djjg;//登记机构
    @Column
    private String yhsqywh;//银行申请业务号
    @Column
    private Integer lzqx;//领证期限
    @Column
    private String wszt;//完税状态0：未缴税    1：已完税    2：系统外收税    3：系统外收税完成
    @Column
    private String dsxtywh;//地税系统业务号
    @Column
    private String sfyjzs;//是否邮寄证书0：否1：是
    @Column
    private String ems_address;//邮寄人地址
    @Column
    private String ems_dh;//邮寄人电话
    @Column
    private String ems_name;//邮寄人姓名
    @Column
    private String postcode;//邮编
    @Column
    private String yzwywh;//一张网业务号
    @Column
    private String qmfs;//签名方式
    @Column
    private String ycslywh;//一窗受理业务号
    @Column
    private String spxtblzt;//审批系统办理状态
    @Column
    private String wwslbh;//外网受理编号
    @Column
    private String wwyyh;//外网预约号
    @Column
    private String qctbslbh;//全城通办受理编号
    @Column
    private String sfscybzs;//是否生成一本证书
    @Column
    private String jjdbh;//交接单编号
    @Column
    private String sfzjtg;//是否资金托管（0，否，1，是）
    @Column
    private String isonline;//是否是线上（0，否，1，是）
    @Column
    private String ywlyjc;//业务来源简称
    private String fzjldyzt;//发证记录打印状态
    private String bdcdyh;//不动产单元号
    private String bdcdybh;//不动产单元编号
    private String sfhcdzzz;//是否合成电子证照
    private String zjtgxybh;//资金托管协议编号
    private String djckh;//登记窗口号
    private String hhlsh;//函号流水号
    private String tysbslptSblsh;// 统一申办受理平台-申报流水号
    private String ysbid;//预申报登记信息ID
    private String sfdwf;//  是否为单位房  (0表示否，1表示是)
    @Crypt(versions = "V1")
    private String lzrzjh;//领证人证件号码
    private String lzrzjzl;//领证人证件类型
    private String dwmc;//单位名称
    @Crypt(versions = "V1")
    private String lzrlxdh;//领证人联系电话
    private String fzwddm;//发证网点代码
    private Integer gyfs;//共有方式
    private Date djsj;//登记时间
    private Integer qszt;//权属状态
    private String dbr;//登簿人
    private String bdcqzh;//不动产权证号
    private String qlr;//权利人
    @Crypt(versions = "V1")
    private String qlrzjh;//权利人证件号
    private String lzfs;//领证方式 1：单独领证2：共同领证
    private String sjwd;//收件网点
    private String zdzhqlxz;//宗地宗海权力性质
    private String ybdcqzmh;//原不动产权证明号
    private String sbjywh;//自助申报机业务号
    private String clyjzt;//材料移交状态
    private String ckqhbh;//窗口取号编号
    private String cjrbm;//创建人部门
    private String htbh;//合同编号
    private String sfsd;//是否收档
    private String sfyzdf;//是否一证多房
    private String sfyy;//是否预约
    private String yybh;//预约编号
    private String xqwywh;//行权网业务号
    private Integer dcsjzs;//督查随机值数
    private String ycqproid;//原产权proid
    private String fgid;//分割ID
    private String sfss;//是否涉税
    private String sfcf;//是否纯房
    private String sfcl;//是否存量
    private String sfydydf;//是否一单元多房
    private String sfxwqy;//是否小微企业
    private String kfjd;//开发进度
    private String fybh;//税费发票号
    private String cthth;//超图合同号
    private String syqx;//使用期限
    private Double jmje;//减免金额
    private String qsbjwybh;//全省办件唯一编号
    private String sfdbzx;//是否登簿注销土地证（1：是 0:否）
    private String sfygxcjsj;//是否已更新创建时间
    private String sfjzjf;//是否集中缴费
    private String ythwwslbh;//一体化外网受理编号
    private String xnbdcdyh;//虚拟不动产单元号
    private String kdxfslbh;//科大讯飞受理编号
    private String sfdyzzzs;//是否打印纸质证书（证明）
    private String sfzzdz;//是否自助打证
    private String yjsid;//一件事id
    private String sfgd;//是否归档  0：否;1：是
    private String tdsyqz;//土地使用权证
    private String sfzxycqz;//是否注销原产权证
    private String dfhh;//电费户号
    private String qsxzbz;//权属性质备注
    private String trqhh;//天然气户号
    private String sfhh;//水费户号
    private String zmsl;//证明数量
    private String rlsbyz;//人脸识别验证(0或空:未通过验证，1:通过验证)
    private String rlsbxx;//人脸识别详细验证信息
    private String rqhh;//燃气户号
    private String cjzdbsc;//创建至登簿时长
    private String cjzbjsc;//创建至办结时长
    private String hjzzda_syd;// 苏易登是否汇交纸质档案
    private String hjzzda;// 是否汇交纸质档案
    private String ywxthq;// 业务系统获取
    private String sfwt;// 是否委托
    private String gzsbh;// 公证书编号
    private String sfqyjzy;//是否企业间转移 0表示否，1表示是
    private String ycslrmc;//一窗受理人名称
    private String ycslrbmmc;//一窗受理人部门名称
}
