package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2022年06月20日
 * @description
 */
public class JaxbNotNullDateAdapter extends XmlAdapter<String, Date> {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");


    @Override
    public Date unmarshal(String s) throws Exception {
        if(StringUtils.isNoneBlank(s)){
            return dateFormat.parse(s);
        }
        return null;
    }

    @Override
    public String marshal(Date date) throws Exception {
        String str ="";
        if (date != null) {
            str = dateFormat.format(date);
        }
        return str;
    }
}
