package cn.gtmap.estateplat.service.server;

import cn.gtmap.estateplat.model.acceptance.YcslxxModel;
import cn.gtmap.estateplat.model.register.DjModel;
import cn.gtmap.estateplat.model.register.WwDjModel;
import cn.gtmap.estateplat.model.server.core.Xmxx;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/7/31
 * @description 不动产项目管理接口
 */
public interface ProjectManageService {
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 根据外网申报登记模型创建不动产登记项目
     * @param djModelList 登记信息
     * @param userid 用户id
     * @return 返回创建信息
     */
    String createProject(List<DjModel> djModelList,String userid);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 根据外网申报登记模型验证不动产登记项目
     * @param djModelList 登记信息
     * @return 返回验证信息
     */
    String validateProject(List<DjModel> djModelList);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据一窗受理模型创建不动产登记项目
     * @param ycslxxModelList 登记信息
     * @param userid 用户id
     * @return 返回创建信息
     */
    String createProjectToYcsl(List<YcslxxModel> ycslxxModelList, String userid);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据一窗受理验证不动产登记项目
     * @param ycslxxModelList 登记信息
     * @return 返回验证信息
     */
    String validateProjectToYcsl(List<YcslxxModel> ycslxxModelList);
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 创建不动产登记项目
     * @param wdid 工作流定义id
     * @param wiid 工作流实例id
     * @param proid 项目id
     * @param userid 用户id
     */
    void createProject(String wdid, String wiid, String proid, String userid);
    /**
     * @author <a href="mailto:zhangyu@gtmap.cn ">zhangyu</a>
     * @description
     * * @param wwdjModelList 外网登记信息
     * @param userid 用户id
     * @return 返回创建信息（登记受理编号，创建成功与否，以及不成功原因）
     */
    Map<String, Object> gxWwCreateProject(List<WwDjModel> wwdjModelList, String userid);
    /**
     * @author <a href="mailto:guting@gtmap.cn ">guting</a>
     * @description
     * * @param wwdjModelList 外网登记信息
     * @param userid 用户id
     * @return 验证外网登记创建信息
     */
    Map<String, Object> gxWwValidateProject(List<WwDjModel> wwdjModelList, String userid);
}
