package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/*
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0, 2017/7/25
 * @description 登簿信息
 */
@XmlType(name = "registerInfo", propOrder = {"totalNum", "firstReg","transferReg","changeReg","logoutReg","riviseReg",
        "dissentingReg","advanceReg","seizeReg","easementReg","mortgageReg","otherReg","businessTypeCount"})
@XmlRootElement(name = "RegisterInfo")
public class RegisterInfo {
    private Integer totalNum;//总数量
    private Integer firstReg;//首次登记数量
    private Integer transferReg;//转移登记数量
    private Integer changeReg;//变更登记数量
    private Integer logoutReg;//注销登记数量
    private Integer riviseReg;//更正登记数量
    private Integer dissentingReg;//异议登记数量
    private Integer advanceReg;//预告登记数量
    private Integer seizeReg;//查封登记数量
    private Integer easementReg;//地役权登记数量
    private Integer mortgageReg;//抵押权登记数量
    private Integer otherReg;//其他登记数量
    private Integer businessTypeCount;//业务类型

    @XmlAttribute(name = "totalNum")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    @XmlAttribute(name = "firstReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getFirstReg() {
        return firstReg;
    }

    public void setFirstReg(Integer firstReg) {
        this.firstReg = firstReg;
    }

    @XmlAttribute(name = "transferReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getTransferReg() {
        return transferReg;
    }

    public void setTransferReg(Integer transferReg) {
        this.transferReg = transferReg;
    }

    @XmlAttribute(name = "changeReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getChangeReg() {
        return changeReg;
    }

    public void setChangeReg(Integer changeReg) {
        this.changeReg = changeReg;
    }

    @XmlAttribute(name = "logoutReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getLogoutReg() {
        return logoutReg;
    }

    public void setLogoutReg(Integer logoutReg) {
        this.logoutReg = logoutReg;
    }

    @XmlAttribute(name = "riviseReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getRiviseReg() {
        return riviseReg;
    }

    public void setRiviseReg(Integer riviseReg) {
        this.riviseReg = riviseReg;
    }

    @XmlAttribute(name = "dissentingReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getDissentingReg() {
        return dissentingReg;
    }

    public void setDissentingReg(Integer dissentingReg) {
        this.dissentingReg = dissentingReg;
    }

    @XmlAttribute(name = "advanceReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getAdvanceReg() {
        return advanceReg;
    }

    public void setAdvanceReg(Integer advanceReg) {
        this.advanceReg = advanceReg;
    }

    @XmlAttribute(name = "seizeReg")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getSeizeReg() {
        return seizeReg;
    }

    public void setSeizeReg(Integer seizeReg) {
        this.seizeReg = seizeReg;
    }

    @XmlAttribute(name = "easementReg")
    public Integer getEasementReg() {
        return easementReg;
    }

    public void setEasementReg(Integer easementReg) {
        this.easementReg = easementReg;
    }

    @XmlAttribute(name = "mortgageReg")
    public Integer getMortgageReg() {
        return mortgageReg;
    }

    public void setMortgageReg(Integer mortgageReg) {
        this.mortgageReg = mortgageReg;
    }

    @XmlAttribute(name = "otherReg")
    public Integer getOtherReg() {
        return otherReg;
    }

    public void setOtherReg(Integer otherReg) {
        this.otherReg = otherReg;
    }


    @XmlAttribute(name = "businessTypeCount")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getBusinessTypeCount() {
        return businessTypeCount;
    }

    public void setBusinessTypeCount(Integer businessTypeCount) {
        this.businessTypeCount = businessTypeCount;
    }
}
