package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.text.DecimalFormat;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2022年06月20日
 * @description
 */
public class JaxbNotNullDoubleThreeAdapter extends XmlAdapter<String, Double> {
    @Override
    public Double unmarshal(String v) throws Exception {
        if(StringUtils.isNoneBlank(v)){
            return Double.parseDouble(v);
        }
        return null;
    }

    @Override
    public String marshal(Double v) throws Exception {
        String str = "";
        if (v != null) {
            DecimalFormat df = new DecimalFormat("0.000");
            str = df.format(v);
        }
        return str;
    }
}
