package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDoubleThreeAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleTwoAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 户信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTT_FW_H")
@Table(name = "KTT_FW_H")
public class KttFwHNew implements Serializable, AccessData {
    final static String ysdm = "6001030140";//要素代码
    private String bdcdyh;//不动产单元号
    private String fwbm;//房屋编码
    private String zrzh;//自然幢号
    private String ljzh;//逻辑幢号
    private String ch;//层号
    private String zl;//坐落
    private String mjdw;//面积单位
    private Double sjcs;//实际层数
    private Integer hh;//户号
    private String shbw;//室号部位
    private String hx;//户型
    private String hxjg;//户型结构
    private String fwyt1;//房屋用途1
    private String fwyt2;//房屋用途2
    private String fwyt3;//房屋用途3
    private Double ycjzmj;//预测建筑面积
    private Double yctnjzmj;//预测套内建筑面积
    private Double ycftjzmj;//预测分摊建筑面积
    private Double ycdxbfjzmj;//预测地下部分建筑面积
    private Double ycqtjzmj;//预测其它建筑面积
    private Double ycftxs;//预测分摊系数
    private Double scjzmj;//实测建筑面积
    private Double sctnjzmj;//实测套内建筑面积
    private Double scftjzmj;//实测分摊建筑面积
    private Double scdxbfjzmj;//实测地下部分建筑面积
    private Double scqtjzmj;//实测其它建筑面积
    private Double scftxs;//实测分摊系数
    private Double gytdmj;//共有土地面积
    private Double fttdmj;//分摊土地面积
    private Double dytdmj;//独用土地面积
    private String fwlx;//房屋类型
    private String fwxz;//房屋性质
    private String fcfht;//房屋分户图
    private String zt;//状态
    private String qxdm;//区县代码

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 主房不动产单元号
     */
    private String zfbdcdyh;

    /**
     * 插入房屋结构名称
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String fwjgmc;

    // 长春特殊需求 其他地区不查这两个字段
    private String ytmc;
    private String zddm;

    private Integer zrzbsm;
    private String pzyt;
    private String sjyt;
    private String fwlxmc;
    private String fwxzmc;
    @XmlAttribute(name="ZRZBSM")
    public Integer getZrzbsm() {
        return zrzbsm;
    }

    public void setZrzbsm(Integer zrzbsm) {
        this.zrzbsm = zrzbsm;
    }
    @XmlAttribute(name="PZYT")
    public String getPzyt() {
        return pzyt;
    }

    public void setPzyt(String pzyt) {
        this.pzyt = pzyt;
    }
    @XmlAttribute(name="SJYT")
    public String getSjyt() {
        return sjyt;
    }

    public void setSjyt(String sjyt) {
        this.sjyt = sjyt;
    }
    @XmlAttribute(name="FWLXMC")
    public String getFwlxmc() {
        return fwlxmc;
    }

    public void setFwlxmc(String fwlxmc) {
        this.fwlxmc = fwlxmc;
    }
    @XmlAttribute(name="FWXZMC")
    public String getFwxzmc() {
        return fwxzmc;
    }

    public void setFwxzmc(String fwxzmc) {
        this.fwxzmc = fwxzmc;
    }

    @XmlAttribute(name="ZDDM")
    public String getZddm()
    {
        return this.zddm;
    }

    public void setZddm(String zddm) {
        this.zddm = zddm;
    }

    @XmlAttribute(name="YTMC")
    public String getYtmc()
    {
        return this.ytmc;
    }

    public void setYtmc(String ytmc) {
        this.ytmc = ytmc;
    }

    @XmlTransient
    public String getZfbdcdyh() {
        return zfbdcdyh;
    }

    public void setZfbdcdyh(String zfbdcdyh) {
        this.zfbdcdyh = zfbdcdyh;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "FWBM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFwbm() {
        return fwbm;
    }

    public void setFwbm(String fwbm) {
        this.fwbm = fwbm;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "ZRZH")
    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    @XmlAttribute(name = "LJZH")
    public String getLjzh() {
        return ljzh;
    }

    public void setLjzh(String ljzh) {
        this.ljzh = ljzh;
    }

    @XmlAttribute(name = "CH")
    public String getCh() {
        return ch;
    }

    public void setCh(String ch) {
        this.ch = ch;
    }

    @XmlAttribute(name = "ZL")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    @XmlAttribute(name = "MJDW")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    @XmlAttribute(name = "SJCS")
    public Double getSjcs() {
        return sjcs;
    }

    public void setSjcs(Double sjcs) {
        this.sjcs = sjcs;
    }

    @XmlAttribute(name = "HH")
    public Integer getHh() {
        return hh;
    }

    public void setHh(Integer hh) {
        this.hh = hh;
    }

    @XmlAttribute(name = "SHBW")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getShbw() {
        return shbw;
    }

    public void setShbw(String shbw) {
        this.shbw = shbw;
    }

    @XmlAttribute(name = "HX")
    public String getHx() {
        return hx;
    }

    public void setHx(String hx) {
        this.hx = hx;
    }

    @XmlAttribute(name = "HXJG")
    public String getHxjg() {
        return hxjg;
    }

    public void setHxjg(String hxjg) {
        this.hxjg = hxjg;
    }

    @XmlAttribute(name = "FWYT1")
    public String getFwyt1() {
        return fwyt1;
    }

    public void setFwyt1(String fwyt1) {
        this.fwyt1 = fwyt1;
    }

    @XmlAttribute(name = "FWYT2")
    public String getFwyt2() {
        return fwyt2;
    }

    public void setFwyt2(String fwyt2) {
        this.fwyt2 = fwyt2;
    }

    @XmlAttribute(name = "FWYT3")
    public String getFwyt3() {
        return fwyt3;
    }

    public void setFwyt3(String fwyt3) {
        this.fwyt3 = fwyt3;
    }

    @XmlAttribute(name = "YCJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getYcjzmj() {
        return ycjzmj;
    }

    public void setYcjzmj(Double ycjzmj) {
        this.ycjzmj = ycjzmj;
    }

    @XmlAttribute(name = "YCTNJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getYctnjzmj() {
        return yctnjzmj;
    }

    public void setYctnjzmj(Double yctnjzmj) {
        this.yctnjzmj = yctnjzmj;
    }

    @XmlAttribute(name = "YCFTJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getYcftjzmj() {
        return ycftjzmj;
    }

    public void setYcftjzmj(Double ycftjzmj) {
        this.ycftjzmj = ycftjzmj;
    }

    @XmlAttribute(name = "YCDXBFJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getYcdxbfjzmj() {
        return ycdxbfjzmj;
    }

    public void setYcdxbfjzmj(Double ycdxbfjzmj) {
        this.ycdxbfjzmj = ycdxbfjzmj;
    }

    @XmlAttribute(name = "YCQTJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getYcqtjzmj() {
        return ycqtjzmj;
    }

    public void setYcqtjzmj(Double ycqtjzmj) {
        this.ycqtjzmj = ycqtjzmj;
    }

    @XmlAttribute(name = "YCFTXS")
    public Double getYcftxs() {
        return ycftxs;
    }

    public void setYcftxs(Double ycftxs) {
        this.ycftxs = ycftxs;
    }

    @XmlAttribute(name = "SCJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScjzmj() {
        return scjzmj;
    }

    public void setScjzmj(Double scjzmj) {
        this.scjzmj = scjzmj;
    }

    @XmlAttribute(name = "SCTNJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getSctnjzmj() {
        return sctnjzmj;
    }

    public void setSctnjzmj(Double sctnjzmj) {
        this.sctnjzmj = sctnjzmj;
    }

    @XmlAttribute(name = "SCFTJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScftjzmj() {
        return scftjzmj;
    }

    public void setScftjzmj(Double scftjzmj) {
        this.scftjzmj = scftjzmj;
    }

    @XmlAttribute(name = "SCDXBFJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScdxbfjzmj() {
        return scdxbfjzmj;
    }

    public void setScdxbfjzmj(Double scdxbfjzmj) {
        this.scdxbfjzmj = scdxbfjzmj;
    }

    @XmlAttribute(name = "SCQTJZMJ")
    public Double getScqtjzmj() {
        return scqtjzmj;
    }

    public void setScqtjzmj(Double scqtjzmj) {
        this.scqtjzmj = scqtjzmj;
    }

    @XmlAttribute(name = "SCFTXS")
    public Double getScftxs() {
        return scftxs;
    }

    public void setScftxs(Double scftxs) {
        this.scftxs = scftxs;
    }

    @XmlAttribute(name = "GYTDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getGytdmj() {
        return gytdmj;
    }

    public void setGytdmj(Double gytdmj) {
        this.gytdmj = gytdmj;
    }

    @XmlAttribute(name = "FTTDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    @XmlAttribute(name = "DYTDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getDytdmj() {
        return dytdmj;
    }

    public void setDytdmj(Double dytdmj) {
        this.dytdmj = dytdmj;
    }

    @XmlAttribute(name = "FWLX")
    public String getFwlx() {
        return fwlx;
    }

    public void setFwlx(String fwlx) {
        this.fwlx = fwlx;
    }

    @XmlAttribute(name = "FWXZ")
    public String getFwxz() {
        return fwxz;
    }

    public void setFwxz(String fwxz) {
        this.fwxz = fwxz;
    }
    @XmlAttribute(name = "FCFHT")
    public String getFcfht() {
        return fcfht;
    }

    public void setFcfht(String fcfht) {
        this.fcfht = fcfht;
    }

    @XmlAttribute(name = "ZT")
    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlTransient
    public String getFwjgmc() {
        return fwjgmc;
    }

    public void setFwjgmc(String fwjgmc) {
        this.fwjgmc = fwjgmc;
    }
}
