/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class CmccSmsServiceImpl
implements SmsService {
    private static final String PHONE_NUMBER_NULL = "\u7535\u8bdd\u53f7\u7801\u4e3a\u7a7a\uff01";
    private static final String CONTENT_NUMBER_NULL = "\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a\uff01";
    private static final String REQDELIVERYREPORT_NO_NUMBER = "\u9700\u8981\u72b6\u6001\u62a5\u544a\u4e0d\u662f\u6570\u5b57\uff01";
    private static final String MSGFMT_NO_NUMBER = "\u6d88\u606f\u7c7b\u578b\u4e0d\u662f\u6570\u5b57\uff01";
    private static final String SENDMETHOD_NO_NUMBER = "\u77ed\u4fe1\u53d1\u9001\u5f62\u5f0f\u4e0d\u662f\u6570\u5b57\uff01";
    private String extCode;
    private String reqDeliveryReport;
    private String msgFmt;
    private String sendMethod;
    private String applicationId;
    private JdbcTemplate jdbcTemplate;

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getExtCode() {
        return this.extCode;
    }

    public void setExtCode(String extCode) {
        this.extCode = extCode;
    }

    public String getReqDeliveryReport() {
        return this.reqDeliveryReport;
    }

    public void setReqDeliveryReport(String reqDeliveryReport) {
        this.reqDeliveryReport = reqDeliveryReport;
    }

    public String getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(String msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getSendMethod() {
        return this.sendMethod;
    }

    public void setSendMethod(String sendMethod) {
        this.sendMethod = sendMethod;
    }

    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        if (StringUtils.isBlank((CharSequence)phoneNum)) {
            throw new AppException(PHONE_NUMBER_NULL);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new AppException(CONTENT_NUMBER_NULL);
        }
        if (!StringUtils.isNumeric((CharSequence)this.reqDeliveryReport)) {
            throw new AppException(REQDELIVERYREPORT_NO_NUMBER);
        }
        if (!StringUtils.isNumeric((CharSequence)this.msgFmt)) {
            throw new AppException(MSGFMT_NO_NUMBER);
        }
        if (!StringUtils.isNumeric((CharSequence)this.sendMethod)) {
            throw new AppException(SENDMETHOD_NO_NUMBER);
        }
        String sql = "INSERT INTO sms_outbox (SISMSID, EXTCODE, DESTADDR,MESSAGECONTENT, REQDELIVERYREPORT, MSGFMT, SENDMETHOD, REQUESTTIME, APPLICATIONID) VALUES (?,?,?,?,?,?,?,?,?)";
        try {
            Object[] param = new Object[]{UUIDGenerator.generate18(), this.extCode, phoneNum, content, Integer.parseInt(this.reqDeliveryReport), Integer.parseInt(this.msgFmt), Integer.parseInt(this.sendMethod), CalendarUtil.getCurHMSDate(), this.applicationId};
            this.jdbcTemplate.update(sql, param);
        }
        catch (Exception e) {
            throw new AppException(e.getMessage());
        }
        return true;
    }
}

