package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDoubleEightAdapter;
import cn.gtmap.estateplat.utils.JaxbNotNullDoubleEightAdapter;
import cn.gtmap.estateplat.utils.JaxbNotNullDoubleThreeAdapter;
import cn.gtmap.estateplat.utils.JaxbNotNullIntegerAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 宗海空间属性
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "ZH_K_105")
@Table(name = "ZH_K_105")
public class ZhKNew implements Serializable, AccessData {
    private String bdcdyh;//不动产单元号
    private Integer zdx;//子对象
    private Integer xh;//序号
    private Double xzb;//X坐标
    private Double yzb;//Y坐标
    private Date updatetime;//更新时间
    private Date createtime;//创建时间
    private Double zzb;
    @XmlAttribute(name = "ZZB")
    @XmlJavaTypeAdapter(JaxbNotNullDoubleThreeAdapter.class)
    public Double getZzb() {
        return zzb;
    }

    public void setZzb(Double zzb) {
        this.zzb = zzb;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZDX")
    @XmlJavaTypeAdapter(JaxbNotNullIntegerAdapter.class)
    public Integer getZdx() {
        return zdx;
    }

    public void setZdx(Integer zdx) {
        this.zdx = zdx;
    }

    @XmlAttribute(name = "XH")
    @XmlJavaTypeAdapter(JaxbNotNullIntegerAdapter.class)
    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    @XmlAttribute(name = "XZB")
    @XmlJavaTypeAdapter(JaxbNotNullDoubleEightAdapter.class)
    public Double getXzb() {
        return xzb;
    }

    public void setXzb(Double xzb) {
        this.xzb = xzb;
    }

    @XmlAttribute(name = "YZB")
    @XmlJavaTypeAdapter(JaxbNotNullDoubleEightAdapter.class)
    public Double getYzb() {
        return yzb;
    }

    public void setYzb(Double yzb) {
        this.yzb = yzb;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
}
