package cn.gtmap.estateplat.service.etl;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2018/5/16
 * @description 交易信息服务
 */
public interface JyxxService {
    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @version 1.0, 2018/5/16
     * @param cqzh 产权证号
     * @return
     * @description 获取存量房交易状态
     */
    String getJyClfHTZt(final String cqzh);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param
     * @description 根据交易编号获取是否贷款信息
     */
    Boolean getSfdkByJybh(String jybh);

    /**
     *@auther <a href="mailto:qijiadong@gtmap.cn">qijiadong</a>
     *@description 根据bdcdyh获取资金托管状态
     */
    String getFundTrusteeshipStatus(String bdcdyh, String jybh, String fwbm);

    /**
     *@auther <a href="mailto:xusong@gtmap.cn">xusong</a>
     *@description 昆山专用，根据jybh获取资金托管状态
     */
    String getKsApiFundTrusteeshipStatus(String jybh);

    /**
     *@auther <a href="mailto:qijiadong@gtmap.cn">qijiadong</a>
     *@description 获取交易合同状态（太仓）
     */
    String getHtZtByCqzh(String cqzh);

    /**
     *@auther <a href="mailto:xusong@gtmap.cn">xusong</a>
     *@description 获取集成平台备案状态（张家港）
     */
    String getJcptHtxxBazt(String bdcdyh);

    /**
     *@auther <a href="mailto:xusong@gtmap.cn">xusong</a>
     *@description 获取集成平台备案状态（张家港）
     */
    String pushZjgSfxxToInternet(String url, String json);

    /**
     *@auther <a href="mailto:xusong@gtmap.cn">xusong</a>
     *@description 检查集成平台数据（张家港）
     */
    String checkJcptData(String bdcdyh);

    /**
     *@auther <a href="mailto:xusong@gtmap.cn">xusong</a>
     *@description 检查太仓收费状态
     */
    String checkTcSfzt(String slbh);

    /**
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @description 获取集成平台是否网签备案（张家港）
     */
    Boolean ValidateJcptHtxxSfBa(String proid,String bdcqzh,String userid);

    /**
     * @author <a href="mailto:xusong@gtmap.cn">xusong</a>
     * @description 获取互联网+文件签名值和证书id
     */
    String getHlwjWjCert(String proid, String wjm);

    /**
     * @author <a href="mailto:xusong@gtmap.cn">xusong</a>
     * @description 是否是污染企业
     */
    String isWrqy(String qlrmc, String qlrzjh);
}
