package cn.gtmap.estateplat.utils;

import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2020-10-16
 * @description 哈希256生成类
 */
public class SHA256Util {

    public static void main(String[] args) throws IOException {
        File srcFile = new File("E:\\320582200903769233.xml");
        String str = FileUtils.readFileToString(srcFile, "UTF-8");
        getSHA256StrXml(str);
    }

    public static String getSHA256StrXml(String str) {
        String sha256 = "";
        try {
            Map map = CompareXmlUtil.xml2map(str, false);
            Document document = CompareXmlUtil.map2xml(map, "Message");
            sha256 = SHA256Util.getSHA256StrJava(document.asXML());
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        return sha256;
    }

    public static String getSHA256StrJava(String str) {
        str = romveSpac(str);
        MessageDigest messageDigest;
        String encodeStr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = byte2Hex(messageDigest.digest());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 去除空格换行
     */
    private static String romveSpac(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; i++) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                /**
                 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
                 * @description 得到一位的进行补0操作
                 */
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

}
