/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sqlInjectStrList = new String();
    private String invalidPage = "/common/404.ftl";
    private Map<String, String> whitePageList = new HashMap<String, String>();

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String currentURL = request.getRequestURI();
        if (MapUtils.isNotEmpty(this.whitePageList)) {
            for (String key : this.whitePageList.keySet()) {
                if (StringUtils.indexOf((CharSequence)currentURL, (CharSequence)key) <= -1) continue;
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        Enumeration params = request.getParameterNames();
        String sql = "";
        while (params.hasMoreElements()) {
            String name = params.nextElement().toString();
            String[] value = request.getParameterValues(name);
            for (int i = 0; i < value.length; ++i) {
                sql = sql + value[i];
            }
        }
        if (SqlInjectFilter.sqlValidate(sql, this.sqlInjectStrList)) {
            response.sendRedirect(request.getContextPath() + this.invalidPage);
            this.logger.error(request.getRequestURI() + ":" + sql + "\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        Object[] arrPage;
        this.sqlInjectStrList = config.getInitParameter("sqlInjectStrList");
        String whitePage = config.getInitParameter("WhitePageList");
        if (StringUtils.isNotBlank((CharSequence)whitePage) && ArrayUtils.isNotEmpty((Object[])(arrPage = whitePage.split(";")))) {
            for (int i = 0; i < arrPage.length; ++i) {
                Object key = arrPage[i];
                this.whitePageList.put((String)key, null);
            }
        }
    }

    protected static boolean sqlValidate(String str, String sqlInjectStrList) {
        str = str.toLowerCase();
        String[] badStrs = sqlInjectStrList.split("\\|");
        for (int i = 0; i < badStrs.length; ++i) {
            if (str.indexOf(badStrs[i]) < 0) continue;
            System.out.println("str = " + str);
            System.out.println("\u975e\u6cd5\u5b57\u7b26: " + badStrs[i]);
            return true;
        }
        return false;
    }
}

