package cn.gtmap.estateplat.service.oneWeb;
/*
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0, 2017/10/12
 * @description 将外网申请数据抽取到共享库
 */

import cn.gtmap.estateplat.model.exchange.national.InfApply;

public interface ApplyData2ShareService {
    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param caseno 编号
     * @param qlr 权利人名称
     * @param qlrzjh 权利人证件号
     * @rerutn
     * @description 将外网申请数据抽取到共享库
     */
    String applyData2Share(String caseno, String qlr, String qlrzjh);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param
     * @rerutn
     * @description 将外网所有的数据抽取到exchange中
     */
    void applyData2ShareAll();

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param infApply 办件基本信息
     * @rerutn
     * @description 生成一张网办件编号
     */
    String makeCaseNo(InfApply infApply);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param proid 登记业务id
     * @rerutn
     * @description 根据业务id获取物流信息，调用webservice接口接入
     */
    String sendEms(String proid);

    /**
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @description 物流信息获取
     */
    String getEmsInfo(String bh,String xflsh,String zwfwzxbm);
}
