package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDecimalThreeWithZeroAdapter;
import cn.gtmap.sdk.mybatis.plugin.annotation.Crypt;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宗地空间属性
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "ZD_K_103")
public class ZdKNew implements Serializable, AccessData {
    private String bdcdyh;//不动产单元号
    private Integer zdx;//子对象
    private Integer xh;//序号
    @Crypt
    private BigDecimal xzb;//X坐标
    @Crypt
    private BigDecimal yzb;//Y坐标
    private Date updatetime;//更新时间
    private Date createtime;//创建时间
    private String djh;//地籍号

    private Double zzb;
    private String kjlx;
    @XmlAttribute(name = "ZZB")
    public Double getZzb() {
        return zzb;
    }

    public void setZzb(Double zzb) {
        this.zzb = zzb;
    }
    @XmlAttribute(name = "KJLX")
    public String getKjlx() {
        return kjlx;
    }

    public void setKjlx(String kjlx) {
        this.kjlx = kjlx;
    }

    @XmlTransient
    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZDX")
    public Integer getZdx() {
        return zdx;
    }

    public void setZdx(Integer zdx) {
        this.zdx = zdx;
    }

    @XmlAttribute(name = "XH")
    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    @XmlAttribute(name = "XZB")
    @XmlJavaTypeAdapter(JaxbDecimalThreeWithZeroAdapter.class)
    public BigDecimal getXzb() {
        return xzb;
    }

    public void setXzb(BigDecimal xzb) {
        this.xzb = xzb;
    }

    @XmlAttribute(name = "YZB")
    @XmlJavaTypeAdapter(JaxbDecimalThreeWithZeroAdapter.class)
    public BigDecimal getYzb() {
        return yzb;
    }

    public void setYzb(BigDecimal yzb) {
        this.yzb = yzb;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
}
